/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _OPACIFY_OPTIONS_INTERNAL
#include "opacify_options.h"

static int displayPrivateIndex;

static CompMetadata opacifyOptionsMetadata;

static CompPluginVTable *opacifyPluginVTable = NULL;
CompPluginVTable opacifyOptionsVTable;

#define GET_OPACIFY_OPTIONS_DISPLAY(d) \
        ((OpacifyOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define OPACIFY_OPTIONS_DISPLAY(d) \
        OpacifyOptionsDisplay *od = GET_OPACIFY_OPTIONS_DISPLAY (d)

#define GET_OPACIFY_OPTIONS_SCREEN(s, od) \
        ((OpacifyOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define OPACIFY_OPTIONS_SCREEN(s) \
        OpacifyOptionsScreen *os = GET_OPACIFY_OPTIONS_SCREEN (s, GET_OPACIFY_OPTIONS_DISPLAY (s->display))

typedef struct _OpacifyOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[OpacifyDisplayOptionNum];
    opacifyDisplayOptionChangeNotifyProc notify[OpacifyDisplayOptionNum];
} OpacifyOptionsDisplay;

typedef struct _OpacifyOptionsScreen
{
    CompOption opt[OpacifyScreenOptionNum];
    opacifyScreenOptionChangeNotifyProc notify[OpacifyScreenOptionNum];
} OpacifyOptionsScreen;

CompAction * opacifyGetToggle (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return &od->opt[OpacifyDisplayOptionToggle].value.action;
}

void opacifySetToggleInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    od->opt[OpacifyDisplayOptionToggle].value.action.initiate = init;
}

void opacifySetToggleTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    od->opt[OpacifyDisplayOptionToggle].value.action.terminate = term;
}

CompOption * opacifyGetToggleOption (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return &od->opt[OpacifyDisplayOptionToggle];
}

void opacifySetToggleNotify (CompDisplay *d, opacifyDisplayOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    od->notify[OpacifyDisplayOptionToggle] = notify;
}

Bool opacifyGetToggleReset (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return od->opt[OpacifyDisplayOptionToggleReset].value.b;
}

CompOption * opacifyGetToggleResetOption (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return &od->opt[OpacifyDisplayOptionToggleReset];
}

void opacifySetToggleResetNotify (CompDisplay *d, opacifyDisplayOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    od->notify[OpacifyDisplayOptionToggleReset] = notify;
}

int opacifyGetTimeout (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return od->opt[OpacifyDisplayOptionTimeout].value.i;
}

CompOption * opacifyGetTimeoutOption (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return &od->opt[OpacifyDisplayOptionTimeout];
}

void opacifySetTimeoutNotify (CompDisplay *d, opacifyDisplayOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    od->notify[OpacifyDisplayOptionTimeout] = notify;
}

Bool opacifyGetInitToggle (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return od->opt[OpacifyDisplayOptionInitToggle].value.b;
}

CompOption * opacifyGetInitToggleOption (CompDisplay *d)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return &od->opt[OpacifyDisplayOptionInitToggle];
}

void opacifySetInitToggleNotify (CompDisplay *d, opacifyDisplayOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    od->notify[OpacifyDisplayOptionInitToggle] = notify;
}

Bool opacifyGetOnlyIfBlock (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return os->opt[OpacifyScreenOptionOnlyIfBlock].value.b;
}

CompOption * opacifyGetOnlyIfBlockOption (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[OpacifyScreenOptionOnlyIfBlock];
}

void opacifySetOnlyIfBlockNotify (CompScreen *s, opacifyScreenOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_SCREEN(s);
    os->notify[OpacifyScreenOptionOnlyIfBlock] = notify;
}

Bool opacifyGetFocusInstant (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return os->opt[OpacifyScreenOptionFocusInstant].value.b;
}

CompOption * opacifyGetFocusInstantOption (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[OpacifyScreenOptionFocusInstant];
}

void opacifySetFocusInstantNotify (CompScreen *s, opacifyScreenOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_SCREEN(s);
    os->notify[OpacifyScreenOptionFocusInstant] = notify;
}

Bool opacifyGetNoDelayChange (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return os->opt[OpacifyScreenOptionNoDelayChange].value.b;
}

CompOption * opacifyGetNoDelayChangeOption (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[OpacifyScreenOptionNoDelayChange];
}

void opacifySetNoDelayChangeNotify (CompScreen *s, opacifyScreenOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_SCREEN(s);
    os->notify[OpacifyScreenOptionNoDelayChange] = notify;
}

CompMatch * opacifyGetWindowMatch (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[OpacifyScreenOptionWindowMatch].value.match;
}

CompOption * opacifyGetWindowMatchOption (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[OpacifyScreenOptionWindowMatch];
}

void opacifySetWindowMatchNotify (CompScreen *s, opacifyScreenOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_SCREEN(s);
    os->notify[OpacifyScreenOptionWindowMatch] = notify;
}

int opacifyGetActiveOpacity (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return os->opt[OpacifyScreenOptionActiveOpacity].value.i;
}

CompOption * opacifyGetActiveOpacityOption (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[OpacifyScreenOptionActiveOpacity];
}

void opacifySetActiveOpacityNotify (CompScreen *s, opacifyScreenOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_SCREEN(s);
    os->notify[OpacifyScreenOptionActiveOpacity] = notify;
}

int opacifyGetPassiveOpacity (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return os->opt[OpacifyScreenOptionPassiveOpacity].value.i;
}

CompOption * opacifyGetPassiveOpacityOption (CompScreen *s)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[OpacifyScreenOptionPassiveOpacity];
}

void opacifySetPassiveOpacityNotify (CompScreen *s, opacifyScreenOptionChangeNotifyProc notify)
{
    OPACIFY_OPTIONS_SCREEN(s);
    os->notify[OpacifyScreenOptionPassiveOpacity] = notify;
}

CompOption * opacifyGetDisplayOption (CompDisplay *d, OpacifyDisplayOptions num)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * opacifyGetScreenOption (CompScreen *s, OpacifyScreenOptions num)
{
    OPACIFY_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo opacifyOptionsDisplayOptionInfo[] = {
    { "toggle", "action", 0, 0, 0 },
    { "toggle_reset", "bool", 0, 0, 0 },
    { "timeout", "int", "<min>0</min><max>10000</max>", 0, 0 },
    { "init_toggle", "bool", 0, 0, 0 },
};

static Bool opacifyOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, char *name, CompOptionValue *value)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, OpacifyDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case OpacifyDisplayOptionToggle:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[OpacifyDisplayOptionToggle])
                (*od->notify[OpacifyDisplayOptionToggle]) (d, o, OpacifyDisplayOptionToggle);
            return TRUE;
        }
        break;
     case OpacifyDisplayOptionToggleReset:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[OpacifyDisplayOptionToggleReset])
                (*od->notify[OpacifyDisplayOptionToggleReset]) (d, o, OpacifyDisplayOptionToggleReset);
            return TRUE;
        }
        break;
     case OpacifyDisplayOptionTimeout:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[OpacifyDisplayOptionTimeout])
                (*od->notify[OpacifyDisplayOptionTimeout]) (d, o, OpacifyDisplayOptionTimeout);
            return TRUE;
        }
        break;
     case OpacifyDisplayOptionInitToggle:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[OpacifyDisplayOptionInitToggle])
                (*od->notify[OpacifyDisplayOptionInitToggle]) (d, o, OpacifyDisplayOptionInitToggle);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * opacifyOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    OPACIFY_OPTIONS_DISPLAY(d);
    *count = OpacifyDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo opacifyOptionsScreenOptionInfo[] = {
    { "only_if_block", "bool", 0, 0, 0 },
    { "focus_instant", "bool", 0, 0, 0 },
    { "no_delay_change", "bool", 0, 0, 0 },
    { "window_match", "match", 0, 0, 0 },
    { "active_opacity", "int", "<min>1</min><max>100</max>", 0, 0 },
    { "passive_opacity", "int", "<min>1</min><max>100</max>", 0, 0 },
};

static Bool opacifyOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, char *name, CompOptionValue *value)
{
    OPACIFY_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, OpacifyScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case OpacifyScreenOptionOnlyIfBlock:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[OpacifyScreenOptionOnlyIfBlock])
                (*os->notify[OpacifyScreenOptionOnlyIfBlock]) (s, o, OpacifyScreenOptionOnlyIfBlock);
            return TRUE;
        }
        break;
     case OpacifyScreenOptionFocusInstant:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[OpacifyScreenOptionFocusInstant])
                (*os->notify[OpacifyScreenOptionFocusInstant]) (s, o, OpacifyScreenOptionFocusInstant);
            return TRUE;
        }
        break;
     case OpacifyScreenOptionNoDelayChange:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[OpacifyScreenOptionNoDelayChange])
                (*os->notify[OpacifyScreenOptionNoDelayChange]) (s, o, OpacifyScreenOptionNoDelayChange);
            return TRUE;
        }
        break;
     case OpacifyScreenOptionWindowMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[OpacifyScreenOptionWindowMatch])
                (*os->notify[OpacifyScreenOptionWindowMatch]) (s, o, OpacifyScreenOptionWindowMatch);
            return TRUE;
        }
        break;
     case OpacifyScreenOptionActiveOpacity:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[OpacifyScreenOptionActiveOpacity])
                (*os->notify[OpacifyScreenOptionActiveOpacity]) (s, o, OpacifyScreenOptionActiveOpacity);
            return TRUE;
        }
        break;
     case OpacifyScreenOptionPassiveOpacity:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[OpacifyScreenOptionPassiveOpacity])
                (*os->notify[OpacifyScreenOptionPassiveOpacity]) (s, o, OpacifyScreenOptionPassiveOpacity);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * opacifyOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    OPACIFY_OPTIONS_SCREEN(s);
    *count = OpacifyScreenOptionNum;
    return os->opt;
}

static Bool opacifyOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    OpacifyOptionsScreen *os;
    
    OPACIFY_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(OpacifyOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &opacifyOptionsMetadata, opacifyOptionsScreenOptionInfo, os->opt, OpacifyScreenOptionNum))
    {
        free (os);
        return FALSE;
    }
    if (opacifyPluginVTable && opacifyPluginVTable->initScreen)
        return opacifyPluginVTable->initScreen (p, s);
    return TRUE;
}

static void opacifyOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (opacifyPluginVTable && opacifyPluginVTable->finiScreen)
        return opacifyPluginVTable->finiScreen (p, s);

    OPACIFY_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, OpacifyScreenOptionNum);

    free (os);
}

static Bool opacifyOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    OpacifyOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(OpacifyOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &opacifyOptionsMetadata, opacifyOptionsDisplayOptionInfo, od->opt, OpacifyDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }
    if (opacifyPluginVTable && opacifyPluginVTable->initDisplay)
        return opacifyPluginVTable->initDisplay (p, d);
    return TRUE;
}

static void opacifyOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (opacifyPluginVTable && opacifyPluginVTable->finiDisplay)
        return opacifyPluginVTable->finiDisplay (p, d);

    OPACIFY_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, OpacifyDisplayOptionNum);

    free (od);
}

static Bool opacifyOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&opacifyOptionsMetadata, "opacify",opacifyOptionsDisplayOptionInfo, OpacifyDisplayOptionNum, opacifyOptionsScreenOptionInfo, OpacifyScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&opacifyOptionsMetadata, "opacify");
    if (opacifyPluginVTable && opacifyPluginVTable->init)
        return opacifyPluginVTable->init (p);
    return TRUE;
}

static void opacifyOptionsFini (CompPlugin *p)
{
    if (opacifyPluginVTable && opacifyPluginVTable->fini)
        return opacifyPluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&opacifyOptionsMetadata);
}

static CompMetadata *
opacifyOptionsGetMetadata (CompPlugin *plugin)
{
    return &opacifyOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!opacifyPluginVTable)
    {
        opacifyPluginVTable = opacifyOptionsGetCompPluginInfo ();
        memcpy(&opacifyOptionsVTable, opacifyPluginVTable, sizeof(CompPluginVTable));
        opacifyOptionsVTable.getMetadata = opacifyOptionsGetMetadata;
        opacifyOptionsVTable.init = opacifyOptionsInit;
        opacifyOptionsVTable.fini = opacifyOptionsFini;
        opacifyOptionsVTable.initDisplay = opacifyOptionsInitDisplay;
        opacifyOptionsVTable.finiDisplay = opacifyOptionsFiniDisplay;
        opacifyOptionsVTable.initScreen = opacifyOptionsInitScreen;
        opacifyOptionsVTable.finiScreen = opacifyOptionsFiniScreen;
        opacifyOptionsVTable.getDisplayOptions = opacifyOptionsGetDisplayOptions;
	opacifyOptionsVTable.setDisplayOption = opacifyOptionsSetDisplayOption;
	opacifyOptionsVTable.getScreenOptions = opacifyOptionsGetScreenOptions;
	opacifyOptionsVTable.setScreenOption = opacifyOptionsSetScreenOption;
	
    }
    return &opacifyOptionsVTable;
}

