;;  -*- coding: iso-2022-7bit  -*-
;;;  x0213-csys.el --- Coding System Definition for JIS X 0213.

;; Copyright (C) 2000 KAWABATA, Taichi
;;                    Miyashita Hisashi
;;                    ARISAWA Akihiro

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, JIS X 0213

;; This program defines coding-system described in JIS X 0213 standard.

(require 'cl)
(require 'x0213-cdef)

(eval-when-compile
  (require 'x0213-sjis))

;;;
;;; translation CCL program
;;;
(define-ccl-program jisx0213-to-jisx0208
  ;; following jisx0213-1 characters translate to jisx0208.
  ;;  33/x 48-78/x 80-115/x
  ;;  34/33-46 ($B"!(B - $B".(B)
  ;;  34/58-65 ($B":(B - $B"A(B)
  ;;  34/74-80 ($B"J(B - $B"P(B)
  ;;  34/92-106 ($B"\(B - $B"j(B)
  ;;  34/114-121 ($B"r(B - $B"y(B)
  ;;  34/126 ($B"~(B)
  ;;  35/48-57 ($B#0(B - $B#9(B)
  ;;  35/65-90 ($B#A(B - $B#Z(B)
  ;;  35/97-122 ($B#a(B - $B#z(B)
  ;;  36/33-115 ($B$!(B - $B$s(B)
  ;;  37/33-118 ($B%!(B - $B%v(B)
  ;;  38/33-56 ($B&!(B - $B&8(B)
  ;;  38/65-88 ($B&A(B - $B&X(B)
  ;;  39/33-65 ($B'!(B - $B'A(B)
  ;;  39/81-113 ($B'Q(B - $B'q(B)
  ;;  40/33-64 ($B(!(B - $B(@(B)
  ;;  79/33-83 ($BO!(B - $BOS(B)
  ;;  116/33-38 ($Bt!(B - $Bt&(B)
  `(0
    ((if (r1 != ,(charset-id 'japanese-jisx0213-1))
	 (end))
     (r2 = (r0 >> 7) & 127)
     (r3 = (r0 & 127))
     (if (r2 == 33)
	 (r1 = ,(charset-id 'japanese-jisx0208)))
     (if (r2 == 34)
	 ((if (r3 >= 33)
	      (if (r3 <= 46)
		  (r1 = ,(charset-id 'japanese-jisx0208))))
	  (if (r3 >= 58)
	      (if (r3 <= 65)
		  (r1 = ,(charset-id 'japanese-jisx0208))))
	  (if (r3 >= 74)
	      (if (r3 <= 80)
		  (r1 = ,(charset-id 'japanese-jisx0208))))
	  (if (r3 >= 92)
	      (if (r3 <= 106)
		  (r1 = ,(charset-id 'japanese-jisx0208))))
	  (if (r3 >= 114)
	      (if (r3 <= 121)
		  (r1 = ,(charset-id 'japanese-jisx0208))))
	  (if (r3 == 126)
	      (r1 = ,(charset-id 'japanese-jisx0208)))))
     (if (r2 == 35)
	 ((if (r3 >= 48)
	      (if (r3 <= 57)
		  (r1 = ,(charset-id 'japanese-jisx0208))))
	  (if (r3 >= 65)
	      (if (r3 <= 90)
		  (r1 = ,(charset-id 'japanese-jisx0208))))
	  (if (r3 >= 97)
	      (if (r3 <= 122)
		  (r1 = ,(charset-id 'japanese-jisx0208))))))
     (if (r2 == 36)
	 ((if (r3 >= 33)
	      (if (r3 <= 115)
		  (r1 = ,(charset-id 'japanese-jisx0208))))))
     (if (r2 == 37)
	 ((if (r3 >= 33)
	      (if (r3 <= 118)
		  (r1 = ,(charset-id 'japanese-jisx0208))))))
     (if (r2 == 38)
	 ((if (r3 >= 33)
	      (if (r3 <= 56)
		  (r1 = ,(charset-id 'japanese-jisx0208))))
	  (if (r3 >= 65)
	      (if (r3 <= 88)
		  (r1 = ,(charset-id 'japanese-jisx0208))))))
     (if (r2 == 39)
	 ((if (r3 >= 33)
	      (if (r3 <= 65)
		  (r1 = ,(charset-id 'japanese-jisx0208))))
	  (if (r3 >= 81)
	      (if (r3 <= 113)
		  (r1 = ,(charset-id 'japanese-jisx0208))))))
     (if (r2 == 40)
	 ((if (r3 >= 33)
	      (if (r3 <= 64)
		  (r1 = ,(charset-id 'japanese-jisx0208))))))
     (if (r2 >= 48)
	 (if (r2 <= 78)
	     (r1 = ,(charset-id 'japanese-jisx0208))))
     (if (r2 == 79)
	 ((if (r3 >= 33)
	      (if (r3 <= 83)
		  (r1 = ,(charset-id 'japanese-jisx0208))))))
     (if (r2 >= 80)
	 (if (r2 <= 115)
	     (r1 = ,(charset-id 'japanese-jisx0208))))
     (if (r2 == 116)
	 ((if (r3 >= 33)
	      (if (r3 <= 38)
		  (r1 = ,(charset-id 'japanese-jisx0208)))))))))

(define-ccl-program jisx0213-to-jisx0212
  ;; following jisx0213-2 characters translate to jisx0212.
  ;;  34/x 38/x 39/x 41/x 42/x 43/x 48-109/x
  `(0
    ((if (r1 != ,(charset-id 'japanese-jisx0213-2))
	 (end))
     (r2 = (r0 >> 7) & 127)
     (r3 = (r0 & 127))
     (if (r2 == 34)
	 (r1 = ,(charset-id 'japanese-jisx0212)))
     (if (r2 == 38)
	 (r1 = ,(charset-id 'japanese-jisx0212)))
     (if (r2 == 39)
	 (r1 = ,(charset-id 'japanese-jisx0212)))
     (if (r2 == 41)
	 (r1 = ,(charset-id 'japanese-jisx0212)))
     (if (r2 == 42)
	 (r1 = ,(charset-id 'japanese-jisx0212)))
     (if (r2 == 43)
	 (r1 = ,(charset-id 'japanese-jisx0212)))
     (if (r2 >= 48)
	 (if (r2 <= 109)
	     (r1 = ,(charset-id 'japanese-jisx0212)))))))

(define-ccl-program jisx0213-to-jisx0208/0212
  `(0
    (call jisx0213-to-jisx0208)
    (call jisx0213-to-jisx0212)))

(define-ccl-program jisx0213-to-jisx0208/0212-string
  `(1
    (loop
     (read-multibyte-character r1 r0)
     (call jisx0213-to-jisx0208/0212)
     (write-multibyte-character r1 r0)
     (repeat))))

(define-ccl-program jisx0208-to-jisx0213
  `(0
    ((if (r1 == ,(charset-id 'japanese-jisx0208))
	 (r1 = ,(charset-id 'japanese-jisx0213-1))))))

(define-ccl-program jisx0212-to-jisx0213
  `(0
    ((if (r1 == ,(charset-id 'japanese-jisx0212))
	 (r1 = ,(charset-id 'japanese-jisx0213-2))))))
       
(define-ccl-program jisx0208/0212-to-jisx0213
  `(0
    (call jisx0208-to-jisx0213)
    (call jisx0212-to-jisx0213)))

(define-ccl-program jisx0208/0212-to-jisx0213-string
  `(1
    (loop
     (read-multibyte-character r1 r0)
     (call jisx0208/0212-to-jisx0213)
     (write-multibyte-character r1 r0)
     (repeat))))

;;;
;;; translation function
;;;
(defun jisx0213-to-jisx0208/0212-string (string)
  (ccl-execute-on-string 'jisx0213-to-jisx0208/0212-string
                         (make-vector 9 nil) string))

(defun jisx0208/0212-to-jisx0213-string (string)
  (ccl-execute-on-string 'jisx0208/0212-to-jisx0213-string
                         (make-vector 9 nil) string))

(defun jisx0213-to-jisx0208/0212-region (beg end)
  (insert
   (jisx0213-to-jisx0208/0212-string
    (prog1 (buffer-substring beg end)
      (delete-region beg end)))))

(defun jisx0208/0212-to-jisx0213-region (beg end)
  (insert
   (jisx0208/0212-to-jisx0213-string
    (prog1 (buffer-substring beg end)
      (delete-region beg end)))))

;;;
;;; Define coding-system
;;;
(make-coding-system 
 'iso-2022-jp-3
 'iso2022
 "ISO 2022 based 7bit encoding for JIS X 0213 (MIME:ISO-2022-JP-3)"
 '(charset-g0 ascii
   charset-g2 t
   seven t
   short t
   mnemonic "ISO7/JP3"
   eol-type nil
   post-read-conversion jisx0213-to-jisx0208/0212-region
   pre-write-conversion jisx0208/0212-to-jisx0213-region
   ))

(make-coding-system 
 'iso-2022-jp-3-compatible
 'iso2022
 "ISO 2022 based 7bit encoding for JIS X 0213 (MIME:ISO-2022-JP-3),
compatible to ISO-2022-JP."
 '(charset-g0 ascii
   charset-g2 t
   seven t
   short t
   mnemonic "ISO7/JP3"
   eol-type nil
   post-read-conversion jisx0213-to-jisx0208/0212-region
   pre-write-conversion jisx0213-to-jisx0208/0212-region
   ))

(make-coding-system
 'euc-jisx0213 'iso2022
 "ISO 2022 based EUC encoding for JIS X 0213 (MIME:EUC-JISX0213)"
 '(charset-g0 ascii
   charset-g1 japanese-jisx0213-1
   charset-g2 katakana-jisx0201
   charset-g3 japanese-jisx0213-2
   short t
   mnemonic "Ja/EUC3"
   post-read-conversion jisx0213-to-jisx0208/0212-region
   pre-write-conversion jisx0208/0212-to-jisx0213-region
   ))

;;;
;;; Shift-JIS
;;;
(eval-and-compile
  (register-code-conversion-map
   'jisx0213-shift-jis-plain-2-odd-decode-map
   (apply (function vector)
	  ?\xF0
	  (mapcar
	   (lambda (x) (+ x 32))
	   '(1 3 5 13 15 79 81 83 85 87 89 91 93))))
  (register-code-conversion-map
   'jisx0213-shift-jis-plain-2-even-decode-map
   (apply (function vector)
	  ?\xF0
	  (mapcar
	   (lambda (x) (+ x 32))
	   '(8 4 12 14 78 80 82 84 86 88 90 92 94)))))

(defvar shift-jisx0213-coding-system-alist
  '((safe-charsets .
		   (ascii
		    japanese-jisx0208
		    katakana-jisx0201
		    japanese-jisx0213-1
		    japanese-jisx0213-2))
    (mime-charset . shift_jisx0213))
  "An alist for japanese-shift-jisx0213 coding systems.")

(eval-when-compile
  (defun jisx0213-shift-jis-template (tr-ccl-program read write &optional macp)
    (mucs-ccl-stream-form
     (mucs-ccl-read 'char-2 read)
     (if macp
	 (if (eq read 'emacs-mule)
	     '((if (r0 == ?\x0A) ((r0 = ?\x0D))))
	   '((if (r0 == ?\x0D) ((r0 = ?\x0A))))))
     `((call ,tr-ccl-program))
     (mucs-ccl-write write))))

(mucs-define-package
 x0213-csys

 (mucs-define-conversion
  shift-jisx0213-unix-stream-encoder
  stream
  (1 ((jisx0213-shift-jis-template
       'jisx0208-to-jisx0213
       'emacs-mule 'shift-jis))))

 (mucs-define-conversion
  shift-jisx0213-unix-stream-decoder
  stream
  (2 ((jisx0213-shift-jis-template
       'jisx0213-to-jisx0208/0212
       'shift-jis 'emacs-mule))))

 (mucs-define-conversion
  shift-jisx0213-dos-stream-encoder
  stream
  (2 ((jisx0213-shift-jis-template
       'jisx0208-to-jisx0213
       'emacs-mule 'shift-jis-dos))))

 (mucs-define-conversion
  shift-jisx0213-dos-stream-decoder
  stream
  (2 ((jisx0213-shift-jis-template
       'jisx0213-to-jisx0208/0212
       'shift-jis 'emacs-mule-dos))))

 (mucs-define-conversion
  shift-jisx0213-mac-stream-encoder
  stream
  (1 ((jisx0213-shift-jis-template
       'jisx0208-to-jisx0213
       'emacs-mule 'shift-jis t))))

 (mucs-define-conversion
  shift-jisx0213-mac-stream-decoder
  stream
  (2 ((jisx0213-shift-jis-template
       'jisx0213-to-jisx0208/0212
       'shift-jis 'emacs-mule t))))

 ;;coding system definition

 (mucs-define-coding-system
  'japanese-shift-jisx0213-unix ?S
  "Shift_JISX0213 encoding for Japanese (MIME: Shift_JISX0213)."
  'shift-jisx0213-unix-stream-decoder
  'shift-jisx0213-unix-stream-encoder
  shift-jisx0213-coding-system-alist
  'unix)

 (mucs-define-coding-system
  'japanese-shift-jisx0213-dos ?S
  "Shift_JISX0213 encoding for Japanese (MIME: Shift_JISX0213)."
  'shift-jisx0213-dos-stream-decoder
  'shift-jisx0213-dos-stream-encoder
  shift-jisx0213-coding-system-alist
  'dos)

 (mucs-define-coding-system
  'japanese-shift-jisx0213-mac ?S
  "Shift_JISX0213 encoding for Japanese (MIME: Shift_JISX0213)."
  'shift-jisx0213-mac-stream-decoder
  'shift-jisx0213-mac-stream-encoder
  shift-jisx0213-coding-system-alist
  'mac)

 (mucs-define-coding-system
  'japanese-shift-jisx0213 ?S
  "Shift_JISX0213 encoding for Japanese (MIME: Shift_JISX0213)."
  'shift-jisx0213-unix-stream-decoder
  'shift-jisx0213-unix-stream-encoder
  shift-jisx0213-coding-system-alist
  [japanese-shift-jisx0213-unix
   japanese-shift-jisx0213-dos
   japanese-shift-jisx0213-mac])

 (mapcar
  (lambda (x)
    (let ((master (car x))
	  (aliases (cdr x)))
      (coding-system-put master 'alias-coding-systems
			 '(japanese-shift-jisx0213))
      (while aliases
	(define-coding-system-alias
	  (car aliases) master)
	(setq aliases (cdr aliases)))))
  '((japanese-shift-jisx0213 shift_jisx0213)
    (japanese-shift-jisx0213-unix shift_jisx0213-unix)
    (japanese-shift-jisx0213-dos shift_jisx0213-dos)
    (japanese-shift-jisx0213-mac shift_jisx0213-mac)))
 )

;;;
;;; langauge-info-alist update.
;;;

(coding-system-put 'japanese-shift-jisx0213 'category
                   'shift-jis)

;(set-language-info "Japanese" 'coding-priority
;		   (let ((cand
;			  '(iso-2022-jp-3-compatible
;			    utf-8 ; utf-16-le utf-16-be
;			    euc-jisx0213 japanese-shift-jisx0213
;			    iso-2022-jp-2))
;			 cs catlist result)
;		     (while cand
;		       (setq cs (car cand)
;			     cand (cdr cand))
;		       (if (and (find-coding-system cs)
;				(coding-system-category cs)
;				(not (memq (coding-system-category cs)
;					   catlist)))
;			   (setq result (cons cs result)
;				 catlist (cons (coding-system-category cs)
;					       catlist))))
;		     (nreverse result)))

(set-language-info "Japanese" 'coding-system 
                   '(iso-2022-jp euc-jisx0213 iso-2022-jp-3
		     japanese-shift-jisx0213
                     euc-japan shift_jis 
                     iso-2022-jp-1978-irv iso-2022-jp-2))

;;;
;;; advices
;;;
(defadvice decode-coding-region
  (around call-post-read-conversion
	  (start end coding-system &optional buffer))
  (let ((func (coding-system-property coding-system 'post-read-conversion))
	(end-marker (set-marker (make-marker) end)))
    ad-do-it
    (if func (funcall func start (marker-position end-marker)))
    (set-marker end-marker nil)))

(defadvice encode-coding-region
  (before call-pre-write-conversion
	  (start end coding-system &optional buffer))
  (let ((func (coding-system-property coding-system 'pre-write-conversion)))
    (if func (funcall func start end))))

(provide 'x0213-csys)
