/*
 * Copyright 2004-2006 Luc Verhaegen.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_MODE_H_
#define _VIA_MODE_H_ 1

/* For Output->Type */
#define OUTPUT_NONE   0x00
#define OUTPUT_CRT    0x01
#define OUTPUT_TV     0x02
#define OUTPUT_PANEL  0x04  /* TTL */
#define OUTPUT_LVDS   0x08  /* usually also a panel */
#define OUTPUT_TMDS   0x10  /* DVI */

/*
 * For Output->Position 
 */
#define OUTPUT_BUS_UNKNOWN  0x00
#define OUTPUT_BUS_CRT      0x01
#define OUTPUT_BUS_DVP0     0x02
#define OUTPUT_BUS_DVP1     0x03
#define OUTPUT_BUS_DFP      0x04

/*
 * Main Output structure.
 */
struct ViaOutput {
    struct ViaOutput *  Prev;
    struct ViaOutput *  Next;

    int  scrnIndex;

    char *Name;

    /* driver side */
    int  Owner; /* Which head owns this? - Driver only. */
    int  Position; /* What bus is this connected to? - Driver only. */
    Bool  Active;
    Bool  ClockMaster;
    MonPtr  Monitor; /* The X structure that holds all monitor related info */
    Bool  ModesExclusive; /* This output will only accept its own modes. */

    /* Shared - 0 when unused */
    CARD32  Type;

    /* Shared - Null when unused */
    I2CDevPtr  I2CDev;
    OptionInfoPtr  Options;

    void (*Save) (struct ViaOutput *Output);
    void (*Restore) (struct ViaOutput *Output);
    Bool (*Sense) (struct ViaOutput *Output);
    ModeStatus (*ModeValid) (struct ViaOutput *Output, DisplayModePtr mode); /* Required */
    void (*Mode) (struct ViaOutput *Output, DisplayModePtr mode); /* Required */
    void (*Power) (struct ViaOutput *Output, Bool On); /* Required */
    void (*PrintRegs) (struct ViaOutput *Output, const char *function);

    /* Privates. */
    int  PrivFlag;
    void  *Private;
    int  PrivSize;
    void (*PrivateDestroy) (struct ViaOutput *Output);
};

/* Function prototypes */
/* via_mode.c */
void ViaVgaPrintRegs(ScrnInfoPtr pScrn, const char *function);

void ViaOutputsDestroy(ScrnInfoPtr pScrn);
void ViaOutputsSave(ScrnInfoPtr pScrn);
void ViaOutputsRestore(ScrnInfoPtr pScrn);
void ViaOutputsPower(ScrnInfoPtr pScrn, Bool On);
void ViaOutputsPrintRegs(ScrnInfoPtr pScrn, const char *function);
void ViaOutputsDetect(ScrnInfoPtr pScrn);
Bool ViaOutputsSelect(ScrnInfoPtr pScrn);
void ViaMonitorInitialise(ScrnInfoPtr pScrn);

ModeStatus ViaValidMode(int scrnIndex, DisplayModePtr mode, Bool verbose, int flags);
void ViaModePrimary(ScrnInfoPtr pScrn, DisplayModePtr mode);
void ViaModeSecondary(ScrnInfoPtr pScrn, DisplayModePtr mode);

/* via_edid.c */
#ifdef XF86_DDC_H /* don't impose xf86DDC.h on all files */
void ViaDDCMonitorSet(int scrnIndex, MonPtr Monitor, xf86MonPtr DDC);
#endif

/* via_modeutils.c */
DisplayModePtr ViaCVTMode(int HDisplay, int VDisplay, float VRefresh, Bool Reduced, Bool Interlaced);
DisplayModePtr ViaModesAdd(DisplayModePtr Modes, DisplayModePtr Additions);
DisplayModePtr ViaModeCopy(DisplayModePtr Mode);
void ViaPrintModeline(int scrnIndex, DisplayModePtr mode);
void ViaModesCopyAdd(MonPtr Monitor, DisplayModePtr Additions);
void ViaMonitorAddModetable(MonPtr Monitor, DisplayModePtr Modes);
void ViaModesDestroy(DisplayModePtr Modes);

/* outputs: via_crt.c, via_panel.c, via_vt162x.c and via_ch7xxx.c */
struct ViaOutput *ViaCRTInit(ScrnInfoPtr pScrn, I2CDevPtr pDev);
struct ViaOutput *ViaPanelInit(ScrnInfoPtr pScrn, I2CDevPtr pDev);
struct ViaOutput *ViaVT162xInit(ScrnInfoPtr pScrn, I2CDevPtr pDev);
struct ViaOutput *ViaCH7xxxInit(ScrnInfoPtr pScrn, I2CDevPtr pDev);

/* I still haven't been able to clean up the panel code. */
void ViaSetSecondaryDotclock(ScrnInfoPtr pScrn, CARD32 clock);
CARD32 ViaPLLGenerate(ScrnInfoPtr pScrn, int Clock);

#endif /* _VIA_MODE_H_ */
