/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include <assert.h>

#include <qinputcontextplugin.h>

#include "scim-bridge.h"
#include "scim-bridge-client-imcontext-qt.h"
#include "scim-bridge-client-qt.h"

/* Static Variables */
static ScimBridgeClientQt *client = NULL;

static int client_ref_count = 0;


/* The class Definition */
class ScimBridgeInputContextPlugin: public QInputContextPlugin 
{

    public:

        ScimBridgeInputContextPlugin ();

        ~ScimBridgeInputContextPlugin ();

        QStringList keys () const;

        QStringList languages (const QString &key);

        QString description (const QString &key);
        
        QInputContext *create (const QString &key);

        QString displayName (const QString &key);

};


/* Implementations */
ScimBridgeInputContextPlugin::ScimBridgeInputContextPlugin ()
{
}


ScimBridgeInputContextPlugin::~ScimBridgeInputContextPlugin () {
    --client_ref_count;
    if (client_ref_count <= 0) {
        delete client;
        client = NULL;
    }
}


QStringList ScimBridgeInputContextPlugin::keys () const {
    QStringList keylist;
    keylist.push_back ("scim-bridge");
    return keylist;
}


QStringList ScimBridgeInputContextPlugin::languages (const QString &key) {
    QStringList lang_list;
    lang_list.push_back ("zh_CN");
    lang_list.push_back ("zh_TW");
    lang_list.push_back ("zh_HK");
    lang_list.push_back ("ja");
    lang_list.push_back ("ko");
    return lang_list;
}


QString ScimBridgeInputContextPlugin::description (const QString &key) {
    return QString::fromUtf8 ("Qt immodule plugin for SCIM Bridge");
}


QInputContext *ScimBridgeInputContextPlugin::create (const QString &key) {
    if (key.lower () != "scim-bridge") {
        return NULL;
    } else {
        if (client == NULL) client = new ScimBridgeClientQt ();
        ++client_ref_count;
        return ScimBridgeClientIMContext::alloc ();
    }
}


QString ScimBridgeInputContextPlugin::displayName (const QString &key) {
    return key;
}


Q_EXPORT_PLUGIN (ScimBridgeInputContextPlugin)
