#!/bin/sh

# usage: overwrite src dst
overwrite() {
    if diff -u $2 $1; then
	rm -f $1
    else
	mv -i $1 $2
    fi
}


perl gene-ptetex.pl
for f in vl3 fc4 fc5 rhel4; do
    overwrite $f ptetex-$f.spec
done

for f in vl3 fc4 fc5 rhel4; do
    perl gene-tetex.pl < ptetex-$f.spec > $f
    overwrite $f tetex-$f.spec
done

perl -n -e 's/%{_var}\/lib\/texmf/\/var\/tmp\/texfonts/;
print unless /^(%attr|mkdir|MAKE_OPTION).*texfonts/;' \
< gene-template > generic
overwrite generic ../ptetex.spec
