#!/usr/bin/perl -w

use strict;
my (%title, %depend, %option, %beforex, %afterx);
my $PTETEX_VER = `date +%Y%m%d`;
chop $PTETEX_VER;

###################################

$title{'vl3'}  = <<'EOF';
# for VineLinux 3.x
%define fontsjp TrueType-sazanami
EOF

$title{'fc4'}  = <<'EOF';
# for Fedora Core 4
%define fontsjp fonts-japanese
EOF

$title{'fc5'}  = <<'EOF';
# for Fedora Core 5
%define fontsjp fonts-japanese
EOF

$title{'rhel4'}  = <<'EOF';
# for Red Hat Enterprise Linux v.4
%define fontsjp ttfonts-ja
EOF

###################################

$depend{'vl3'} = <<'EOF';
Requires: ed mktemp
PreReq:        ghostscript %{fontsjp}
BuildRequires: ghostscript %{fontsjp}
BuildRequires: build-essential bison flex
BuildRequires: zlib-devel libpng-devel ncurses-devel
BuildRequires: XOrg-devel openMotif-devel
Provides: tetex = 3.0 tetex-extra tetex-doc
Provides: xdvik dvipdfmx dvipng jvf tetex-macros texmacro-otf
EOF

$depend{'fc4'} = <<'EOF';
Requires: ed mktemp
PreReq:        ghostscript %{fontsjp}
BuildRequires: ghostscript %{fontsjp}
BuildRequires: bison flex
BuildRequires: zlib-devel libpng-devel gd-devel libjpeg-devel ncurses-devel
BuildRequires: xorg-x11-devel openmotif-devel
Provides: tetex = 3.0 tetex-latex tetex-fonts tetex-afm
Provides: tetex-dvips tetex-xdvi  tetex-doc
EOF

$depend{'fc5'} = <<'EOF';
Requires: ed mktemp
PreReq:        ghostscript %{fontsjp}
BuildRequires: ghostscript %{fontsjp}
BuildRequires: bison flex
BuildRequires: zlib-devel libpng-devel gd-devel libjpeg-devel ncurses-devel
BuildRequires: xorg-x11-proto-devel openmotif-devel
Provides: tetex = 3.0 tetex-latex tetex-fonts tetex-afm
Provides: tetex-dvips tetex-xdvi  tetex-doc
EOF

$depend{'rhel4'} = $depend{'fc4'};

###################################

$option{'vl3'} = <<'EOF';
EOF

$option{'fc4'}   = $option{'vl3'};
$option{'fc5'}   = $option{'vl3'};
$option{'rhel4'} = $option{'vl3'};

###################################

$beforex{'vl3'} = <<'EOF';
# remove useless entry in 7font-search.sh
perl -ni -e 'print "alias /usr/share/fonts/alias/TrueType\n" if /^truetype/;
	s/sazanami-mincho/mincho-mr-jisx0208.1983-0/;
	s/sazanami-gothic/gothic-mr-jisx0208.1983-0/;
	print unless /^X11TTF / or /^Acrobat/ or /^\s(df|lx).*\.ttc/' \
	7font-search.sh
EOF

$beforex{'fc4'} = <<'EOF';
# remove useless entry in 7font-search.sh
perl -ni -e 'print unless /^X11TTF / or /^Acrobat/' 7font-search.sh
EOF

$beforex{'fc5'}   = $beforex{'fc4'};
$beforex{'rhel4'} = $beforex{'fc4'};

###################################

$afterx{'vl3'} = <<'EOF';
# avoid dependency on perl-Tk
rm -rf teTeX/share/texmf-dist/scripts/context/perl
EOF

$afterx{'fc4'} = <<'EOF' . $afterx{'vl3'};
# modify input method for xdvi
perl -pi -e 's/(\*inputMethod: kinput2)/! \1/' \
    src/tetex-src-3.0/texk/xdvik/texmf/XDvi
EOF

$afterx{'fc5'} = $afterx{'fc4'};
$afterx{'rhel4'} = $afterx{'fc4'};

###################################

my $dist;
foreach $dist ('vl3', 'fc4', 'fc5', 'rhel4') {
    open(SPEC, "< gene-template");
    open(OUT,  "> $dist");
    <SPEC>; # dummy read
    print OUT $title{$dist};
    while (<SPEC>) {
	s/\@PTETEX_VER\@/$PTETEX_VER/g;
	print OUT $option{$dist}  if /^EOF/;
	print OUT $beforex{$dist} if /^# extract files/;
	print OUT;
	print OUT $afterx{$dist}  if /^make .* x$/;
	print OUT $depend{$dist}  if /^Group:/;
    }
    close(SPEC);
    close(OUT);
}
