#!/bin/sh
#
# ptetex -- Japanese patch collection for teTeX-3.0
#  Nobuyuki Tsuchimura
#

. ./common.sh
PREFIX=$1
DATA=$2
TEXMF=$DATA/texmf
SRC=$3/tetex-src-$TETEX_VER

test -z "$REAL_PREFIX" && REAL_PREFIX=$PREFIX
test -z "$REAL_DATA"   && REAL_DATA=$DATA

install="prefix=$PREFIX texmf=$TEXMF datadir=$DATA install"

## arg check
if test -z "$3"; then
cat <<EOF
usage : $0 'tex-directory' 'data-directory' 'src-directory'
ex.:    $0 /usr/local/teTeX /usr/local/teTeX/share /usr/local/src
EOF
exit 1
fi

unset TEXINPUTS
unset HOME
##
## To set enviroment variable, edit "../my_option".
##

date
if test "$JAPANESE" != "without"; then
## freetype for xdvi-jp
if test "$SYSTEM_FREETYPE2" = "no"; then
    echo "[--freetype--] configure"
    cd $SRC/freetype || exit
    GNUMAKE=$MAKE ./configure || exit
    echo "[--freetype--] make"
    $MAKE || exit

    for f in $SRC/texk/*xdvik/configure; do
	perlprint \
	"s@freetype-config --ftversion@echo 2.1.10@g;
	 s@freetype-config --cflags@echo -I../../freetype/include@g;
	 s@freetype-config --libs@sh ../../freetype/builds/unix/freetype-config --libs | sed -e 's|-lfreetype|../../freetype/objs/.libs/libfreetype.a|'@" \
	     $f
    done
fi
fi # "$JAPANESE" != "without"

echo "[--tetex--] configure"
cd $SRC || exit
./configure --prefix=$REAL_PREFIX --datadir=$REAL_DATA \
    --disable-multiplatform \
    $CONF_OPTION || exit
echo "[--tetex--] make"
$MAKE $MAKE_OPTION || exit
echo "[--tetex--] make install"
$MAKE $MAKE_OPTION $install || exit


if test "$JAPANESE" != "without"; then
$MKDIR $TEXMF/xdvi || exit
cat <<EOF > $TEXMF/xdvi/vfontmap || exit
%
% vfontmap -- Do NOT edit this file BY HAND!!
%
% An effective file is
% "$REAL_DATA/texmf-var/fonts/map/xdvi/updmap/vfontmap"
% which is generated by 'updmap-sys'.
%
% Use "updmap-sys --setoption xdviRml mincho-font"
% and "updmap-sys --setoption xdviGbm gothic-font".
%
EOF


echo "[--ptex--] configure"
cd $SRC/texk/web2c/ptex || exit
./configure $KANJI_CODE || exit
echo "[--ptex--] make"
$MAKE $MAKE_OPTION || exit
echo "[--ptex--] make install"
LD_LIBRARY_PATH=$PREFIX/lib $MAKE $MAKE_OPTION $install || exit


echo "[--jmpost--] configure"
cd jmpost || exit
chmod +x configure
./configure || exit
echo "[--jmpost--] make"
$MAKE $MAKE_OPTION || exit
echo "[--jmpost--] make install"
LD_LIBRARY_PATH=$PREFIX/lib $MAKE $MAKE_OPTION $install || exit


echo "[--mendexk--] configure"
cd $SRC/texk/mendexk || exit
./configure $KANJI_CODE || exit
echo "[--mendexk--] make"
$MAKE $MAKE_OPTION || exit
echo "[--mendexk--] make install"
LD_LIBRARY_PATH=$PREFIX/lib $MAKE $MAKE_OPTION $install || exit


echo "[--dvipdfmx--] configure"
cd $SRC/texk/dvipdfmx || exit
LD_LIBRARY_PATH=$PREFIX/lib ./configure --with-kpathsea=$PREFIX \
    --prefix=$REAL_PREFIX --datadir=$REAL_DATA || exit
echo "[--dvipdfmx--] make"
LD_LIBRARY_PATH=$PREFIX/lib $MAKE $MAKE_OPTION || exit
echo "[--dvipdfmx--] install"
LD_LIBRARY_PATH=$PREFIX/lib $MAKE $MAKE_OPTION $install || exit

$MKDIR $TEXMF/fonts/cmap || exit
$MKDIR $TEXMF/fonts/map/dvipdfm || exit
mv $TEXMF/dvipdfm/CMap $TEXMF/fonts/cmap/dvipdfm || exit
mv $TEXMF/dvipdfm/config/glyphlist.txt $TEXMF/fonts/map/dvipdfm || exit
fi # "$JAPANESE" != "without"

## disable mktexlsr (texhash)
#echo "% disable ls-R" > $TEXMF/ls-R

strip $PREFIX/bin/* $PREFIX/lib/libkpathsea.* 2> /dev/null
PATH=$PREFIX/bin:$PATH
TEXMFMAIN=$TEXMF
LD_LIBRARY_PATH=$PREFIX/lib
export PATH TEXMFMAIN LD_LIBRARY_PATH
$MKTEXLSR || exit
$UPDMAP 2> /dev/null || exit
date

cat <<EOF
------------------------------
'ptetex3' was installed successfully.

for sh/bash user
export PATH=$PREFIX/bin:\$PATH

for csh/tcsh user
setenv PATH $PREFIX/bin:\$PATH

To uninstall
rm -rf $PREFIX $SRC
------------------------------

EOF
