#!/bin/sh
#
# ptetex -- Japanese patch collection for teTeX-3.0
#  Nobuyuki Tsuchimura
#

. ./common.sh
TEXMF=$1/texmf
MAP=$TEXMF/fonts/map/dvipdfm

## arg check
if test -z "$1"; then
cat <<EOF
usage : $0 'data-directory'
ex.:    $0 /usr/local/teTeX/share
EOF
exit 1
fi

shouldnotexist $TEXMF

## start
if test -z "$TEXMFDIST"; then
    shouldnotexist $TEXMF-dist
    tarx $SRC_DIR/tetex-texmf-$TEXMF_VER.tar.gz $TEXMF-dist
# for RPM (don't depend on 'eval')
    chmod -x $TEXMF-dist/scripts/*/*.pl || exit
fi

# dvips doesn't print
distcp $TEXMF dvips/config config.ps
perlprint 's/^(o \|lpr)/% \1/' $TEXMF/dvips/config/config.ps

## for dvips (pstricks)
tarx archive/dvipsk-5.95b-p1.7a.tar.gz $PTETEX_TMP
distcp $TEXMF dvips/pstricks pst-text.pro
cpatch $PTETEX_TMP/PSTricks.patch 0 $TEXMF/dvips/pstricks


if test "$JAPANESE" != "without"; then
## for ptex
tarx archive/ptex-texmf-2.4.tar.gz $TEXMF
eightbit2hex $TEXMF tex/latex/url url.sty
mv $TEXMF/COPYRIGHT*  $TEXMF/doc/ptex || exit
mv $TEXMF/Changes.txt $TEXMF/doc/ptex || exit
mv $TEXMF/README.txt  $TEXMF/doc/ptex || exit

## for platex209
tarx archive/platex209.tar.gz      $TEXMF/ptex
echo "\input plplain.tex \dump" >  $TEXMF/ptex/platex209/plplain.ini

## for updmap
distcp $TEXMF web2c updmap.cfg
cat <<EOF >> $TEXMF/web2c/updmap.cfg || exit

# kanjiEmbed {noEmbed|hiragino|kozuka|morisawa|ipa|etc..}
kanjiEmbed noEmbed

# Japanese font map
KanjiMap ptex-@kanjiEmbed@.map
#! KanjiMap utf-@kanjiEmbed@.map
#! KanjiMap otf-@kanjiEmbed@.map
#! KanjiMap otf-cktx.map
KanjiMap morisawa.map

EOF

$MKDIR $MAP || exit
cat <<EOF > $MAP/ptex-noEmbed.map || exit
%%
%% ASCII pTeX
%%

rml	H	!Ryumin-Light
rmlv	V	!Ryumin-Light
gbm	H	!GothicBBB-Medium
gbmv	V	!GothicBBB-Medium
EOF
perl -pe 's/\!Ryumin-Light/ipam.ttf/g; 
	  s/\!GothicBBB-Medium/ipag.ttf/g;' \
	      < $MAP/ptex-noEmbed.map > $MAP/ptex-ipa.map
perl -pe 's/\!Ryumin-Light/HiraMinPro-W3/g; 
	  s/\!GothicBBB-Medium/HiraKakuPro-W6/g;' \
	      < $MAP/ptex-noEmbed.map > $MAP/ptex-hiragino.map
perl -pe 's/\!Ryumin-Light/KozMinPro-Regular-Acro.otf/g; 
	  s/\!GothicBBB-Medium/KozGoStd-Regular.otf/g;' \
	      < $MAP/ptex-noEmbed.map > $MAP/ptex-kozuka.map
perl -pe 's/\!Ryumin-Light/A-OTF-RyuminPro-Light.otf/g; 
	  s/\!GothicBBB-Medium/A-OTF-GothicBBBPro-Medium.otf/g;' \
	      < $MAP/ptex-noEmbed.map > $MAP/ptex-morisawa.map

cat <<EOF > $MAP/morisawa.map || exit
%%
%% Morisawa
%%
ryumin-l    H	Ryumin-Light
ryumin-l-v  V	Ryumin-Light
gtbbb-m     H	GothicBBB-Medium
gtbbb-m-v   V	GothicBBB-Medium
futomin-b   H	FutoMinA101-Bold
futomin-b-v V	FutoMinA101-Bold
futogo-b    H	FutoGoB101-Bold
futogo-b-v  V	FutoGoB101-Bold
jun101-l    H	Jun101-Light
jun101-l-v  V	Jun101-Light
EOF

## for jis/jisg/morisawa
tarx archive/jis.tar.gz $PTETEX_TMP
$CP $PTETEX_TMP/jis/tfm/ptex/* $TEXMF/fonts/tfm/ptex/ || exit
$CP $PTETEX_TMP/jis/vf/*       $TEXMF/fonts/vf/ptex/  || exit

tarx archive/morisawa.tar.gz $PTETEX_TMP
$CP $PTETEX_TMP/morisawa/tfm/dvips/* $TEXMF/fonts/tfm/ptex/ || exit
$CP $PTETEX_TMP/morisawa/tfm/ptex/*  $TEXMF/fonts/tfm/ptex/ || exit
$CP $PTETEX_TMP/morisawa/vf/*        $TEXMF/fonts/vf/ptex/  || exit

## replace same vf file with symbolic link
(cd $TEXMF/fonts/vf/ptex || exit
for f in *10.vf; do
    if test ! -h $f; then
        for g in *min*.vf *goth*.vf; do
            if test ! -h $g -a $f != $g; then
                cmp $f $g > /dev/null && ($RM $g; $LN $f $g)
            fi
        done
    fi
done
)

## doc
$MKDIR $TEXMF/doc/ptetex || exit
$CP README* ChangeLog LICENSE $TEXMF/doc/ptetex || exit

## dvipdfmx
tarx archive/dvipdfmx-contrib-latex.tar.gz $TEXMF/tex/latex/graphics
fi # "$JAPANESE" != "without"


# Fix marvosym.sty (impoted from FC4)
# http://www.ntg.nl/pipermail/ntg-vtex/2003-September/000338.html
# I cannot find any mention of incompatibility
# in the document but the following shows ':'
# instead of '=>' if marvosym.sty is loaded.
#
# Regards,
# Shigeru Miyata
#
# \documentclass{article}
# %\usepackage{marvosym}
#
# \begin{document}
# $\Rightarrow$
# \end{document}
distcp $TEXMF tex/latex/marvosym marvosym.sty
cpatch archive/tetex-3.0-marvosym-rightarrow.patch 2 $TEXMF

## post
$RM -r $PTETEX_TMP
(cd $TEXMF || exit
test "$UID" = 0 && chown -R 0:0 .
chmod -R og-w .
find . -type d -name CVS        -exec $RM -r '{}' \; 2> /dev/null
find . -type f -name .cvsignore -exec $RM    '{}' \;
)
echo ""


## check
cat md5sum/texmf | (cd $TEXMF; md5check) && exit
cat <<EOF

$0: Some processes were performed improperly.
Check if you have GNU patch.
Some environment variables (TEXMF, LD_LIBRARY_PATH, etc) may make side effect.

EOF
exit 1
