#!/usr/bin/perl

use lib "../src/.libs";
use lib $ENV{PWD} . "/blib/lib";
use lib $ENV{PWD} . "/blib/arch";

use MeCab;

my %Node;

sub search ()
{
    my $rnode = shift @_;
    my $rid   = $rnode->{id};   #  Node  ID
    my $bcost = $rnode->{cost}; #  Node  Ŭ
    $Node{$rid} = $rnode;       # ϤȤդ
    

    #  Node ³뤹٤Ƥ Path ˤĤ..
    for (my $p = $rnode->{lpath}; $p; $p = $p->{lnext}) {
	my $lnode = $p->{lnode};	
	if ($lnode->{isbest} || $p->{cost} <= 4000) {  # ʲΤΤߤĤ
	    my $lid   = $lnode->{id};
	    next if (defined $Node{$lid}); # ĤƤΤ̵
	    &search ($lnode);  # lnode 򿷤Ƥˤ, Ƶ
	}
    }
}

my $m = new MeCab::Tagger ("-l3"); # -a Ĥ, õԤʤ.
my $n = $m->parseToNode ("⤷ʤȤ"); 

# ä ʸޤܺ
for (; $n->{next}; $n = $n->{next} ) {};

# ͥ, õ
&search ($n);

for my $id (sort {$a <=> $b} keys %Node) {
    print $Node{$id}->{isbest} ? "* " : "  ";  # Best ξ, * ɽ
    print $id, "\t", $Node{$id}->{feature}, "\n";
}
