/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2005 by the KFTPGrabber developers
 * Copyright (C) 2003-2005 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */


#include <qlayout.h>

#include <kdebug.h>
#include <klocale.h>

#include "qcut.h"
#include "dialog.h"
#include "dialogwidget.h"
#include "listview.h"

namespace KFTPWidgets {

namespace ServerManagement {

Dialog::Dialog()
 : KDialogBase(KDialogBase::Plain, i18n("Site Command Dialog"), KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok)
{
}


Dialog::~Dialog()
{
}

void Dialog::showDialog(ListViewItem *item)
{
  // Set current item that was executed
  m_item = item;
  
  // Get the command from the first column
  m_command = m_item->text(0);

  // Check for arguments like <group> in m_command
  if (checkArguments()) {
    // Create a custom dialog
    createDialog();
    connect(this, SIGNAL(okClicked()), this, SLOT(slotSendCommand()));
    
    exec();
  } else {
    // No stuff in the dialog, return the blank site command
    emit command(true, m_command);
  }
}

bool Dialog::checkArguments()
{
  QString arg;

  for (uint i = 0; i <= m_command.length(); ++i) {
    arg = QString::null;

    QString c = m_command.mid( i, 1 );

    if (c == "[") {
      do {
      ++i;
      arg += c;
      c = m_command.mid( i, 1 );
      } while (c != "]");
      arg += c;
      m_dialogWidgets.append(new DialogWidget(m_item, arg, plainPage(), QString("KFTPServerManagementDialogWidget "+arg).ascii()));
    }

    if (c == "<") {
      do {
      ++i;
      arg += c;
      c = m_command.mid( i, 1 );
      } while (c != ">");
      arg += c;
      m_dialogWidgets.append(new DialogWidget(m_item, arg, plainPage(), QString("KFTPServerManagementDialogWidget "+arg).ascii()));
    }
  }

  if (m_dialogWidgets.isEmpty())
    return false; // Don't create a dialog
  else
    return true; // create a dialog

}

void Dialog::createDialog()
{
  // new layout for all widgets in the dialog
  m_layout = new QGridLayout(plainPage(), 0, 0, 11, 6, "dialogLayout");

  // layout integer
  int l = 0;

  DialogWidget *dialogWidget;
  QPtrListIterator<DialogWidget> it(m_dialogWidgets);

  for ( ; (dialogWidget = it.current()) != 0; ++it, ++l) {
    m_layout->addWidget(it.current(), l, 0);
  }
}

void Dialog::slotSendCommand()
{
  // Remove all characters from < to the end of the line
  // e.g.
  // command before: site stat <value>
  // command after: site stat
  m_command = QCut().cut( "", "<", m_command, 0, 1 );
  m_command = QCut().cut( "", "[", m_command, 0, 1 );

  int l = 0;

  DialogWidget *dialogWidget;
  QPtrListIterator<DialogWidget> it(m_dialogWidgets);

//   for (; (dialogWidget = it.current()) != 0; ++it, ++l) {
  while ((dialogWidget = it.current()) != 0) {
    if (!dialogWidget->optional()) { // maybe the attribute was optional
      if (dialogWidget->text().isEmpty()) { // no text returned
        emit command(false, dialogWidget->error()); // attribute was not optional, send a error message
        return;
      } else {
        m_command += dialogWidget->text();
      }
    } else {
      m_command += dialogWidget->text();
    }
    ++it;
    ++l;
  }

  // send the command to KFTPServerManagementListView::slotSendCommand(QString)
  emit command(true, m_command);
}

}

}

#include "dialog.moc"
