/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPFILEDIRVIEWACTIONS_H
#define KFTPFILEDIRVIEWACTIONS_H

#include <qobject.h>
#include <kaction.h>
#include <krun.h>
#include <kservice.h>
#include <kuserprofile.h>

namespace KFTPWidgets {

namespace Browser {

class View;

/**
@author Jernej Kos
*/
class Actions : public QObject
{
Q_OBJECT
friend class View;
friend class ListView;
public:
    Actions(QObject *parent = 0, const char *name = 0);

    void initActions();
    void updateActions();
private:
    KAction *m_goUpAction;
    KAction *m_goBackAction;
    KAction *m_goForwardAction;
    KAction *m_goHomeAction;
    KAction *m_reloadAction;
    
    KAction *m_abortAction;
    KToggleAction *m_toggleTreeViewAction;
    KToggleAction *m_toggleFilterAction;

    KAction *m_transferAction;
    KAction *m_queueTransferAction;
    KAction *m_createDirAction;
    KAction *m_fileEditAction;
    KAction *m_verifyAction;

    KActionMenu *m_moreActions;
    KAction *m_rawCmdAction;
    KActionMenu *m_changeEncodingAction;
    KAction *m_exportListingAction;
    KToggleAction *m_showHiddenFilesAction;

    KActionMenu *m_siteChangeAction;
    KAction *m_quickConnectAction;
    KActionMenu *m_connectAction;
    KAction *m_disconnectAction;

    KActionCollection *actionCollection();

    View *m_dirView;
    
    int m_curCharsetOption;
    int m_defaultCharsetOption;
    
    void populateEncodings();
private slots:
    void slotGoUp();
    void slotGoBack();
    void slotGoForward();
    void slotGoHome();
    void slotReload();
    
    void slotAbort();
    void slotShowHideTree();
    void slotShowHideFilter();

    void slotTransfer();
    void slotQueueTransfer();
    void slotCreateDir();
    void slotFileEdit();
    void slotVerify();
    
    void slotRawCmd();
    void slotCharsetChanged(int);
    void slotCharsetReset(int);
    void slotExportListing();
    void slotShowHiddenFiles();

    void slotQuickConnect();
    void slotDisconnect();
};

}

}

#endif
