/***************************************************************************
* $Id: WidgetView.java 141456 2002-03-07 02:57:29Z rdale $
**
* Definition of something or other
**
* Created : 979899
**
* Copyright (C) 1997 by Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/


import org.kde.qt.*;

class WidgetView  extends QMainWindow
{

private String MOVIEFILENAME = "trolltech.gif";
private QLabel     msg;
private QCheckBox  cb[] = new QCheckBox[3];
private QGroupBox bg;
private QLabel     movielabel;
private QMovie      movie;
private QWidget central;
private QProgressBar prog;
private int progress;
private QTabWidget tabs;
private QMultiLineEdit edit;
private QPopupMenu textStylePopup;
private int plainStyleID;
private QWidget bla;
private AnalogClock aclock;
private DigitalClock dclock;

/* XPM */
static String[] filesave = {
"    14    14        4            1",
". c #040404",
"# c #808304",
"a c #bfc2bf",
"b c None",
"..............",
".#.aaaaaaaa.a.",
".#.aaaaaaaa...",
".#.aaaaaaaa.#.",
".#.aaaaaaaa.#.",
".#.aaaaaaaa.#.",
".#.aaaaaaaa.#.",
".##........##.",
".############.",
".##.........#.",
".##......aa.#.",
".##......aa.#.",
".##......aa.#.",
"b............."
};

/* XPM */
static String[] fileopen = {
"    16    13        5            1",
". c #040404",
"# c #808304",
"a c None",
"b c #f3f704",
"c c #f3f7f3",
"aaaaaaaaa...aaaa",
"aaaaaaaa.aaa.a.a",
"aaaaaaaaaaaaa..a",
"a...aaaaaaaa...a",
".bcb.......aaaaa",
".cbcbcbcbc.aaaaa",
".bcbcbcbcb.aaaaa",
".cbcb...........",
".bcb.#########.a",
".cb.#########.aa",
".b.#########.aaa",
"..#########.aaaa",
"...........aaaaa"
};

/* XPM */
static String[] fileprint = {
"    16    14        6            1",
". c #000000",
"# c #848284",
"a c #c6c3c6",
"b c #ffff00",
"c c #ffffff",
"d c None",
"ddddd.........dd",
"dddd.cccccccc.dd",
"dddd.c.....c.ddd",
"ddd.cccccccc.ddd",
"ddd.c.....c....d",
"dd.cccccccc.a.a.",
"d..........a.a..",
".aaaaaaaaaa.a.a.",
".............aa.",
".aaaaaa###aa.a.d",
".aaaaaabbbaa...d",
".............a.d",
"d.aaaaaaaaa.a.dd",
"dd...........ddd"
};

// Standard Qt widgets



class MyListView  extends QListView
{
public    MyListView( QWidget  parent )
{
	this(parent, null);
}
public    MyListView( QWidget  parent, String name )
{
    super( parent, name );
	selected = null;
}
protected void contentsMousePressEvent( QMouseEvent  e )
    {
	selected = selectedItem();
//	super.contentsMousePressEvent( e );
    }
protected void contentsMouseReleaseEvent( QMouseEvent  e )
    {
//	super.contentsMouseReleaseEvent( e );
	if ( selectedItem() != selected ) {
	    emit("mySelectionChanged", selectedItem() );
	    emit("mySelectionChanged");
	}
    }

private    QListViewItem selected;
}
//
// WidgetView contains lots of Qt widgets.
//



// Some sample widgets





/*
class MyWhatsThis  extends QWhatsThis
{
public    MyWhatsThis( QListBox lb)
{
    super( lb );
	listbox = lb; 
}


public  String text( QPoint  p) {
	QListBoxItem i = listbox.itemAt( p );
	if ( i != null && i.pixmap() != null ) {
	    return "Isn't that a <em>wonderful</em> pixmap? <br>"
		+ "Imagine, you could even decorate a"
		+ " <b>red</b> pushbutton with it! :-)";
	}
	return "This is a QListBox.";
    }

private    QListBox listbox;
}


class MyMenuItem  extends QCustomMenuItem
{
public    MyMenuItem( String s, QFont f )
{
	string = s;
	font = f;
}

    public void paint( QPainter p, QColorGroup cg, boolean act,
		boolean enabled, int x, int y, int w, int h )
    {
	p.setFont ( font );
	p.drawText( x, y, w, h,
		     AlignAuto | AlignVCenter | ShowPrefix | DontClip,
		     string );
    }

    public QSize sizeHint()
    {
	return QFontMetrics( font ).size( AlignAuto | AlignVCenter |
					  ShowPrefix | DontClip,  string );
    }
private    String string;
private    QFont font;
}
*/


//
// Construct the WidgetView with children
//

WidgetView( QWidget parent, String name )
{
    super( parent, name );
    QColor col = new QColor();

    // Set the window caption/title
    setCaption( "Qt Example - Widgets Demo Application" );

    // create a toolbar
    QToolBar tools = new QToolBar( this, "toolbar" );

    // put something in it
    QPixmap openIcon = new QPixmap( fileopen );
    QToolButton  toolb = new QToolButton( new QIconSet(openIcon), "toolbutton 1",
					   "", this, SLOT("open()"),
					   tools, "open file" );
    QWhatsThis.add( toolb, "This is a <b>QToolButton</b>. It lives in a "
		     + "QToolBar. This particular button doesn't do anything "
		     + "useful." );

    QPixmap saveIcon = new QPixmap( filesave );
    toolb = new QToolButton( new QIconSet(saveIcon), "toolbutton 2", "",
			     this, SLOT("dummy()"),
			     tools, "save file" );
    QWhatsThis.add( toolb, "This is also a <b>QToolButton</b>." );

    QPixmap  printIcon = new QPixmap( fileprint );
    toolb = new QToolButton( new QIconSet(printIcon), "toolbutton 3", "",
			     this, SLOT("dummy()"),
			     tools, "print file" );
    QWhatsThis.add( toolb, "This is the third <b>QToolButton</b>.");

    toolb = QWhatsThis.whatsThisButton( tools );
    QWhatsThis.add( toolb, "This is a <b>What's This</b> button "
		     + "It enables the user to ask for help "
		     + "about widgets on the screen.");

    // Install an application-global event filter to catch control+leftbutton
    qApp().installEventFilter( this );

    //make a central widget to contain the other widgets
    central = new QWidget( this );
    setCentralWidget( central );

    // Create a layout to position the widgets
    QHBoxLayout topLayout = new QHBoxLayout( central, 10 );

    // Create a grid layout to hold most of the widgets
    QGridLayout grid = new QGridLayout( 0, 3 ); //3 wide and autodetect number of rows
    topLayout.addLayout( grid, 1 );

    // Create an easter egg
    QToolTip.add( menuBar(), new QRect( 0, 0, 2, 2 ), "easter egg" );

    QPopupMenu popup;
    popup = new QPopupMenu( this );
    menuBar().insertItem( "&File", popup );
    int id;
    id = popup.insertItem( "&New" );
    popup.setItemEnabled( id, false );
    id = popup.insertItem( new QIconSet(openIcon), "&Open", this, SLOT(" open()") );

    popup.insertSeparator();
    popup.insertItem( "&Quit", qApp(), SLOT("quit()"), new QKeySequence(CTRL+Key_Q) );


    textStylePopup = popup = new QPopupMenu( this );
    menuBar().insertItem( "&Edit", popup );

    plainStyleID = id = popup.insertItem( "&Plain" );
    popup.setAccel( new QKeySequence(CTRL+Key_T), id );

    popup.insertSeparator();
/*    QFont f = font();
    f.setBold( true );
    id = popup.insertItem( new MyMenuItem( "&Bold", f ) );
    popup.setAccel( new QKeySequence(CTRL+Key_B), id );
    f = font();
    f.setItalic( true );
    id = popup.insertItem( new MyMenuItem( "&Italic", f ) );
    popup.setItemChecked( id, true );
    popup.setAccel( new QKeySequence(CTRL+Key_I), id );
    f = font();
    f.setUnderline( true );
    id = popup.insertItem( new MyMenuItem( "&Underline", f ) );
    popup.setAccel( new QKeySequence(CTRL+Key_U), id );
    f = font();
    f.setStrikeOut( true );
    id = popup.insertItem( new MyMenuItem( "&Strike", f ) );
    connect( textStylePopup, SIGNAL("activated(int)"),
	     this, SLOT("popupSelected(int)") );
*/
    // Create an analog and a digital clock
    aclock = new AnalogClock( central );
    aclock.setAutoMask( true );
    dclock = new DigitalClock( central );
    dclock.setMaximumWidth(200);
    grid.addWidget( aclock, 0, 2 );
    grid.addWidget( dclock, 1, 2 );

    // Give the dclock widget a blue palette
    col.setRgb( 0xaa, 0xbe, 0xff );
    dclock.setPalette( new QPalette( col ) );

    // make tool tips for both of them
    QToolTip.add( aclock, "custom widget: analog clock" );
    QToolTip.add( dclock, "custom widget: digital clock" );

    // Create a push button.
    QPushButton pb;
    pb = new QPushButton( "&Push button 1", central, "button1" );
    grid.addWidget( pb, 0, 0, AlignVCenter );
    connect( pb, SIGNAL("clicked()"), SLOT("button1Clicked()") );
    QToolTip.add( pb, "push button 1" );
    QWhatsThis.add( pb, "This is a <b>QPushButton</b>.<br>"
		     + "Click it and watch...<br>"
		     + "The wonders of modern technology.");

    QPixmap pm = new QPixmap();
    boolean pix = pm.load("qt.png");
    if ( !pix ) {
	QMessageBox.information( null, "Qt Widgets Example",
				  "Could not load the file \"qt.png\", which\n"
				  + "contains an icon used...\n\n"
				  + "The text \"line 42\" will be substituted.",
				  QMessageBox.Ok + QMessageBox.Default );
    }

    // Create a label containing a QMovie
    movie = new QMovie( MOVIEFILENAME );
    movielabel = new QLabel( central, "label0" );
    movie.connectStatus(this, SLOT("movieStatus(int)"));
    movie.connectUpdate(this, SLOT("movieUpdate(QRect)"));
    movielabel.setFrameStyle( QFrame.Box | QFrame.Plain );
    movielabel.setMovie( movie );
    movielabel.setFixedSize( 128+movielabel.frameWidth()*2,
			      64+movielabel.frameWidth()*2 );
    grid.addWidget( movielabel, 0, 1, AlignCenter );
    QToolTip.add( movielabel, "movie" );
    QWhatsThis.add( movielabel, "This is a <b>QLabel</b> "
		     + "that contains a QMovie." );

    // Create a group of check boxes
    bg = new QButtonGroup( central, "checkGroup" );
    bg.setTitle( "Check Boxes" );
    grid.addWidget( bg, 1, 0 );

    // Create a layout for the check boxes
    QVBoxLayout vbox = new QVBoxLayout(bg, 10);

    vbox.addSpacing( bg.fontMetrics().height() );

    cb[0] = new QCheckBox( bg );
    cb[0].setText( "&Read" );
    vbox.addWidget( cb[0] );
    cb[1] = new QCheckBox( bg );
    cb[1].setText( "&Write" );
    vbox.addWidget( cb[1] );
    cb[2] = new QCheckBox( bg );
    cb[2].setText( "&Execute" );
    vbox.addWidget( cb[2] );

    connect( bg, SIGNAL("clicked(int)"), SLOT("checkBoxClicked(int)") );

    QToolTip.add( cb[0], "check box 1" );
    QToolTip.add( cb[1], "check box 2" );
    QToolTip.add( cb[2], "check box 3" );

    // Create a group of radio buttons
    QRadioButton rb;
    bg = new QButtonGroup( central, "radioGroup" );
    bg.setTitle( "Radio buttons" );

    grid.addWidget( bg, 1, 1 );

    // Create a layout for the radio buttons
    vbox = new QVBoxLayout(bg, 10);

    vbox.addSpacing( bg.fontMetrics().height() );
    rb = new QRadioButton( bg );
    rb.setText( "&AM" );
    rb.setChecked( true );
    vbox.addWidget(rb);
    QToolTip.add( rb, "radio button 1" );
    rb = new QRadioButton( bg );
    rb.setText( "F&M" );
    vbox.addWidget(rb);
    QToolTip.add( rb, "radio button 2" );
    rb = new QRadioButton( bg );
    rb.setText( "&Short Wave" );
    vbox.addWidget(rb);

    connect( bg, SIGNAL("clicked(int)"), SLOT("radioButtonClicked(int)") );
    QToolTip.add( rb, "radio button 3" );

    // Create a list box
    QListBox lb = new QListBox( central, "listBox" );
    for ( int i=0; i<100; i++ ) {		// fill list box
	String str = "line " + i;
	if ( i == 42 && pix )
	    lb.insertItem( pm );
	else
	    lb.insertItem( str );
    }
    grid.addMultiCellWidget( lb, 2, 4, 0, 0 );
    connect( lb, SIGNAL("selected(int)"), SLOT("listBoxItemSelected(int)") );
    QToolTip.add( lb, "list box" );
//    new MyWhatsThis( lb );

    vbox = new QVBoxLayout(8);
    grid.addLayout( vbox, 2, 1 );

    // Create a slider
    QSlider sb = new QSlider( 0, 300, 30, 100, QSlider.Horizontal,
			       central, "Slider" );
    sb.setTickmarks( QSlider.Below );
    sb.setTickInterval( 10 );
    sb.setFocusPolicy( QWidget.TabFocus );
    vbox.addWidget( sb );

    connect( sb, SIGNAL("valueChanged(int)"), SLOT("sliderValueChanged(int)") );
    QToolTip.add( sb, "slider" );
    QWhatsThis.add( sb, "This is a <b>QSlider</b>. "
		     + "The tick marks are optional."
		     + " This slider controls the speed of the movie." );
    // Create a combo box
    QComboBox combo = new QComboBox( false, central, "comboBox" );
    combo.insertItem( "darkBlue" );
    combo.insertItem( "darkRed" );
    combo.insertItem( "darkGreen" );
    combo.insertItem( "blue" );
    combo.insertItem( "red" );
    vbox.addWidget( combo );
    connect( combo, SIGNAL("activated(int)"),
	     this, SLOT("comboBoxItemActivated(int)") );
    QToolTip.add( combo, "read-only combo box" );

    // Create an editable combo box
    QComboBox edCombo = new QComboBox( true, central, "edComboBox" );
    edCombo.insertItem( "Permutable" );
    edCombo.insertItem( "Malleable" );
    edCombo.insertItem( "Adaptable" );
    edCombo.insertItem( "Alterable" );
    edCombo.insertItem( "Inconstant" );
    vbox.addWidget( edCombo );
    connect( edCombo, SIGNAL("activated(String)"),
	     this, SLOT("edComboBoxItemActivated(String)") );
    QToolTip.add( edCombo, "editable combo box" );

    edCombo.setAutoCompletion( true );

    vbox = new QVBoxLayout(8);
    grid.addLayout( vbox, 2, 2 );

    // Create a spin box
    QSpinBox spin = new QSpinBox( 0, 10, 1, central, "spin" );
    spin.setSuffix(" mm");
    spin.setSpecialValueText( "Auto" );
    connect( spin, SIGNAL(" valueChanged(String)"),
	     SLOT(" spinBoxValueChanged(String)") );
    QToolTip.add( spin, "spin box" );
    QWhatsThis.add( spin, "This is a <b>QSpinBox</b>. "
		     + "You can chose values in a given range "
		     + "either by using the arrow buttons "
		     + "or by typing them in." );
    vbox.addWidget( spin );

    vbox.addStretch( 1 );

    // Create a tabwidget that switches between multi line edits
    tabs = new QTabWidget( central );
    //tabs.setTabPosition( QTabWidget.Bottom );
    tabs.setMargin( 4 );
    grid.addMultiCellWidget( tabs, 3, 3, 1, 2 );
    QMultiLineEdit mle = new QMultiLineEdit( tabs, "multiLineEdit" );
    edit = mle;
    mle.setWordWrap( QMultiLineEdit.WidgetWidth );
    mle.setText("This is a QMultiLineEdit widget, "
	         + "useful for small multi-line "
		 + "input fields.");
    QToolTip.add( mle, "multi line editor" );

    tabs.addTab( mle, "F&irst");

    mle = new QMultiLineEdit( tabs, "multiLineEdit" );
    String mleText = "This is another QMultiLineEdit widget.";
    mleText += "\n";
    mleText += "Japanese: ";
    mleText += (char) 0x6a38; // Kanji
    mleText += "\n";
    mleText += "Russian:";
    mleText += (char) 0x042e; // Cyrillic
    mleText += "\n";
    mleText += "Norwegian:";
    mleText += (char) 0x00d8; // Norwegian
    mleText += "\n";
    mleText += "Unicode (black square):";
    mleText += (char) 0x25A0; // BLACK SQUARE
    mleText += "\n";
    mle.setText( mleText );
    QToolTip.add( mle, "second multi line editor" );
    tabs.addTab( mle, "Se&cond");


    // Create a single line edit
    QLineEdit le = new QLineEdit( central, "lineEdit" );


    grid.addMultiCellWidget( le, 4, 4, 1, 2 );
    connect( le, SIGNAL("textChanged(String)"),
	     SLOT("lineEditTextChanged(String)") );
    QToolTip.add( le, "single line editor" );
    QWhatsThis.add( le, "This is a <b>QLineEdit</b>, you can enter a "
		     + "single line of text in it. "
		     + "It also it accepts text drops." );

    grid.setRowStretch(0,0);
    grid.setRowStretch(1,0);
    grid.setRowStretch(2,0);
    grid.setRowStretch(3,1);
    grid.setRowStretch(4,0);

    grid.setColStretch(0,1);
    grid.setColStretch(1,1);
    grid.setColStretch(2,1);


    QSplitter split = new QSplitter( Vertical, central, "splitter" );
    split.setOpaqueResize( true );
    topLayout.addWidget( split, 1 );
    QListView lv = new MyListView( split );
    connect(lv, SIGNAL("selectionChanged()"),
	    this, SLOT(" selectionChanged()") );
    connect(lv, SIGNAL("selectionChanged(QListViewItem)"),
	    this, SLOT(" selectionChanged(QListViewItem)") );
    connect(lv, SIGNAL("clicked(QListViewItem)"),
	    this, SLOT(" clicked(QListViewItem)") );
    connect(lv, SIGNAL("mySelectionChanged(QListViewItem)"),
	    this, SLOT(" mySelectionChanged(QListViewItem)") );
    lv.addColumn( "One" );
    lv.addColumn( "Two" );
    lv.setAllColumnsShowFocus( true );

    QListViewItem lvi=  new QListViewItem( lv, "Text", "Text" );
    lvi=  new QListViewItem( lv, "Text", "Other Text" );
    lvi=  new QListViewItem( lv, "Text", "More Text" );
    lvi=  new QListViewItem( lv, "Text", "Extra Text" );
    lvi.setOpen(true);
    new QListViewItem( lvi, "SubText", "Additional Text" );
    lvi=  new QListViewItem( lvi, "SubText", "Side Text" );
    lvi=  new QListViewItem( lvi, "SubSubText", "Complimentary Text" );

    QToolTip.add( lv, "list view" );
    QWhatsThis.add( lv, "This is a <b>QListView</b>, you can display lists "
		     + "(or outline lists) of multiple-column data in it." );

    lv = new QListView( split );
    lv.addColumn( "Choices" );
    new QCheckListItem( lv, "Onion", QCheckListItem.CheckBox );
    new QCheckListItem( lv, "Artichoke", QCheckListItem.CheckBox );
    new QCheckListItem( lv, "Pepper", QCheckListItem.CheckBox );
    new QCheckListItem( lv, "Habaneros", QCheckListItem.CheckBox );
    new QCheckListItem( lv, "Pineapple", QCheckListItem.CheckBox );
    new QCheckListItem( lv, "Ham", QCheckListItem.CheckBox );
    new QCheckListItem( lv, "Pepperoni", QCheckListItem.CheckBox );
    new QCheckListItem( lv, "Garlic", QCheckListItem.CheckBox );


    QCheckListItem lit = new QCheckListItem( lv, "Cheese" );
    lit.setOpen( true );
    new QCheckListItem( lit, "Cheddar", QCheckListItem.RadioButton );
    new QCheckListItem( lit, "Mozarella", QCheckListItem.RadioButton );
    new QCheckListItem( lit, "Jarlsberg", QCheckListItem.RadioButton );

    QToolTip.add( lv, "list view" );
    QWhatsThis.add( lv, "This is also a <b>QListView</b>, with "
		     + "interactive items." );

     QTextView qmlv =  new QTextView( "<hr><h1>QTextView</h1>"
		      + "<p>Qt supports formatted rich text, such "
		      + "as the heading above, <em>emphasized</em> and "
		      + "<b>bold</b> text, via an XML subset.</p> "
		      + "<p>Style sheets are supported.</p>",
 				  "", split );
    qmlv.setFont(new QFont("Charter",11));
    qmlv.setFrameStyle( QFrame.WinPanel | QFrame.Sunken );

    // Create an label and a message in the status bar
    // The message is updated when buttons are clicked etc.
    msg = new QLabel( statusBar(), "message" );
    msg.setAlignment( AlignCenter );
    QFont boldfont = new QFont(); boldfont.setWeight(QFont.Bold);
    msg.setFont( boldfont );
    statusBar().addWidget( msg, 4 );
    QToolTip.add( msg, "Message area" );

    QAccel a = new QAccel( this );
    a.connectItem(  a.insertItem( new QKeySequence(Key_F9) ),
		     this, SLOT(" showProperties()") );

    prog = new QProgressBar( statusBar(), "progress" );
    prog.setTotalSteps( 100 );
    progress = 64;
    prog.setProgress( progress );
    statusBar().addWidget( prog , 1 );
    QWhatsThis.add( prog, "This is a <b>QProgressBar</b> "
		     + "You can use it to show that a lengthy "
		     + " process is progressing. "
		     + "In this program, nothing much seems to happen." );
    statusBar().message( "Welcome to Qt", 2000 );
}

void setStatus(String text)
{
    msg.setText(text);
}

void button1Clicked()
{
    msg.setText( "The push button was clicked" );
    prog.setProgress( ++progress );
}


void movieUpdate( QRect r )
{
    // Uncomment this to test animated icons on your window manager
    //setIcon( movie.framePixmap() );
}

void movieStatus( int s )
{
    switch ( s ) {
      case QMovie.SourceEmpty:
      case QMovie.UnrecognizedFormat:
	{
	    QPixmap pm = new QPixmap("tt-logo.png");
	    movielabel.setPixmap(pm);
	    movielabel.setFixedSize(pm.size());
	}
      break;
      default:
	if ( movielabel.movie() != null )	 	// for flicker-free animation:
	    movielabel.setBackgroundMode( NoBackground );
    }
}


void popupSelected( int selectedId )
{
    if ( selectedId == plainStyleID ) {
	for ( int i = 0; i < textStylePopup.count(); i++ ) {
	    int id = textStylePopup.idAt( i );
	    textStylePopup.setItemChecked( id, false);
	}
    } else {
	textStylePopup.setItemChecked( selectedId, true );
    }
}

void checkBoxClicked( int id )
{
    String str;
    str = tr("Check box " + id + " clicked : ");
    String chk = (cb[0].isChecked() ? "r" : "-")
    + (cb[1].isChecked() ? "w" : "-")
    + (cb[2].isChecked() ? "x" : "-");
    str += chk;
    msg.setText( str );
}


void edComboBoxItemActivated( String text)
{
    String str = tr("Editable Combo Box set to ");
    str += text;
    msg.setText( str );
}


void radioButtonClicked( int id )
{
    msg.setText( tr("Radio button #" + id + " clicked") );
}


void listBoxItemSelected( int index )
{
    msg.setText( tr("List box item " + index +"  selected") );
}


void sliderValueChanged( int value )
{
    msg.setText( tr("Movie set to " + value + "% of normal speed") );
    movie.setSpeed( value );
}


void comboBoxItemActivated( int index )
{
    msg.setText( tr("Combo box item " + index + " activated") );
    switch ( index ) {
    default:
    case 0:
	QApplication.setWinStyleHighlightColor( darkBlue() );
	break;
    case 1:
	QApplication.setWinStyleHighlightColor( darkRed() );
	break;
    case 2:
	QApplication.setWinStyleHighlightColor( darkGreen() );
	break;
    case 3:
	QApplication.setWinStyleHighlightColor( blue() );
	break;
    case 4:
	QApplication.setWinStyleHighlightColor( red() );
	break;
    }
}



void lineEditTextChanged( String newText )
{
    String str = "Line edit text: ";
    str += newText;
    if ( newText.length() == 1 ) {
	String u = " (U" + newText + "x" + newText + "x)";
	str += u;
    }
    msg.setText( str );
}


void spinBoxValueChanged( String valueText )
{
    String str = "Spin box value: " ;
    str += valueText;
    msg.setText( str );
}

//
// All application events are passed through this event filter.
// We're using it to display some information about a clicked
// widget (right mouse button + CTRL).
//

    
static boolean identify_now = true;

public boolean eventFilter( QObject obj, QEvent event )
{
    if ( event.type() == QEvent.MouseButtonPress && event instanceof QMouseEvent && identify_now ) {
	QMouseEvent e = (QMouseEvent)event;
	if ( e.button() == QMouseEvent.RightButton &&
	     (e.state() & QMouseEvent.ControlButton) != 0 ){
	    String str = "The clicked widget is a\n";
	    str += obj.className();
	    str += "\nThe widget's name is\n";
	    if ( !obj.name().equals("") )
		str += obj.name();
	    else
		str += "<no name>";
	    identify_now = false;		// don't do it in message box
	    QMessageBox.information( (QWidget)obj, "Identify Widget", str );
	    identify_now = true;		// allow it again
	}
    }
//    return super.eventFilter( obj, event ); // don't eat event
    return false; // don't eat event
}


void open()
{
    QFileDialog.getOpenFileName( "", "Textfiles (.txt)", this );
}


void dummy()
{
    QMessageBox.information( this, "Sorry",
			      "This function is not implemented" );
}

void selectionChanged()
{
    //qDebug("selectionChanged");
}
void selectionChanged( QListViewItem item)
{
    //qDebug("selectionChanged %p", item );
}

void clicked( QListViewItem item )
{
    //qDebug("clicked %p", item );
}

void mySelectionChanged( QListViewItem item )
{
    //qDebug("mySelectionChanged %p", item );
}

void showProperties()
{
    if ( qApp().focusWidget() == null )
	return;
    String output = "Properties for class '" + qApp().focusWidget().className() + "'";
    int i = 0;
    while( i < (int) qApp().focusWidget().metaObject().numProperties( true ) ) {
	QMetaProperty p
	    = qApp().focusWidget().metaObject().property( i, true );
	String tmp = "\n " + (++i) + ": " + p.name() 
	             + " (read-" + (p.writable() ? "write" : "only") + ", " + p.type() + ")";
	output += tmp;
    }
    qDebug( output );
}
}
