/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib/gi18n.h>

#include "folder.h"

static GPassEntryClass *parent_class = NULL;

static const gchar *
folder_class_nick(void)
{
    return _("Folder");
}

static const gchar *
folder_class_icon_id(void)
{
    return "gtk-directory";
}

static gboolean
folder_class_can_have_child(void)
{
    return TRUE;
}

static void
folder_instance_init(GTypeInstance *instance, gpointer g_class)
{
    GPassFolder *self = GPASS_FOLDER(instance);
    
    GPASS_ENTRY(self)->type = "folder";
}

static void
folder_class_init(gpointer g_class, gpointer g_class_data)
{
    GPassEntryClass *entry_class = GPASS_ENTRY_CLASS(g_class);

    parent_class = g_type_class_peek_parent(g_class);
    
    entry_class->nick = folder_class_nick;
    entry_class->icon_id = folder_class_icon_id;
    entry_class->can_have_child = folder_class_can_have_child;
}

GType
gpass_folder_get_type(void)
{
    static GType type = 0;
    
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof(GPassFolderClass),
            NULL,
            NULL,
            folder_class_init,
            NULL,
            NULL,
            sizeof(GPassFolder),
            0,
            folder_instance_init
        };
        
        type = g_type_register_static(GPASS_TYPE_ENTRY, "GPassFolder",
                                      &info, 0);
    }
    return type;
}
