/*
 * XCellTextCompact.java
 *
 * Created on 6. M?rz 2003, 18:05
 */
package com.sun.star.wizards.tutorial.executer.officeHelper;

import java.util.Hashtable;

/**
 * Spreadsheet text cell interface.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public interface XCellTextCompact {
    /**
     * Insert text.
     *
     * @param Accessibility object path
     * @param Text insert index
     * @param Insert text
     */
    public void insertTexttoCell(String[] path, int index, String insertText);

    /**
     * Move mouse to accessibility object and insert text.
     *
     * @param Accessibility object path
     * @param Text insert index
     * @param Insert text
     */
    public void moveMousetoCell_insertText(String[] path, int index, String insertText);

    /**
     * Delete text. To delete the whole text - startindex=0, endindex=-1
     *
     * @param Accessibility object path
     * @param Delete text start index
     * @param Delete text end index
     */
    public void deleteCellText(String[] path, int startIndex, int endIndex);

    /**
     * Move mouse to accessibility object and delete text. To delete the whole text -
     * startindex=0, endindex=-1
     *
     * @param Accessibility object path
     * @param Delete text start index
     * @param Delete text end index
     */
    public void moveMousetoCell_deleteText(String[] path, int startIndex, int endIndex);

    /**
     * Replace text.
     *
     * @param Accessibility object path
     * @param Search text
     * @param Insert text
     */
    public void replaceCellText(String[] path, String text, String replacement);

    /**
     * Replace text. To replace the whole text - startindex=0, endindex=-1
     *
     * @param Accessibility object path
     * @param Replace start index
     * @param Replace end index
     */
    public void replaceCellText(String[] path, String replacement, int startIndex, int endIndex);

    /**
     * Move mouse to object and replace text.
     *
     * @param Accessibility object path
     * @param Search text
     * @param Insert text
     */
    public void moveMousetoCell_replaceText(String[] path, String text, String replacement);

    /**
     * Move mouse to accessibility object and replace text. To replace the whole text -
     * startindex=0, endindex=-1
     *
     * @param Accessibility object path
     * @param Replace start index
     * @param Replace end index
     */
    public void moveMousetoCell_replaceText(String[] path, String replacement, int startIndex, int endIndex);

    /**
     * Set text
     *
     * @param Accessibility object path
     * @param Set text
     */
    public void setCellText(String[] path, String replacement);

    /**
     * Move mouse to accessibility object and set text
     *
     * @param Accessibility object path
     * @param Insert text
     */
    public void moveMousetoCell_setText(String[] path, String replacement);

    /**
     * This class returns the methods of this interface. This class is very important for
     * the TutorialCreator class.
     *
     * @author $author$
     * @version $Revision: 1.3 $
     */
    public class XCellCompactMethods {
        private static final Hashtable m_xhash;

        static {
            m_xhash = getXCellTextCompact();
        }

        /**
         * Get methods
         *
         * @return hashtable
         */
        public static Hashtable getMethods() {
            return m_xhash;
        }

        /**
         * Creates the hashtable with all methods of this interface.
         *
         * @return hashtable
         */
        private static Hashtable getXCellTextCompact() {
            String[][] insertTexttoCell = new String[][] { { "typ", "" }, {
                    "method", "insertTexttoCell" }, {
                    "path", "" }, {
                    "index", "" }, {
                    "insertText", "" }
            };

            String[][] moveMousetoCell_insertText = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoCell_insertText" }, {
                    "path", "" }, {
                    "index", "" }, {
                    "insertText", "" }
            };

            String[][] deleteCellText = new String[][] { { "typ", "" }, {
                    "method", "deleteCellText" }, {
                    "path", "" }, {
                    "startIndex", "" }, {
                    "endIndex", "" }
            };

            String[][] moveMousetoCell_deleteText = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoCell_deleteText" }, {
                    "path", "" }, {
                    "startIndex", "" }, {
                    "endIndex", "" }
            };

            String[][] replaceCellText = new String[][] { { "typ", "" }, {
                    "method", "replaceCellText" }, {
                    "path", "" }, {
                    "text", "" }, {
                    "replacement", "" }
            };

            String[][] replaceCellText1 = new String[][] { { "typ", "" }, {
                    "method", "replaceCellText" }, {
                    "path", "" }, {
                    "replaceText", "" }, {
                    "startIndex", "" }, {
                    "endIndex", "" }
            };

            String[][] moveMousetoCell_replaceText = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoCell_replaceText" }, {
                    "path", "" }, {
                    "text", "" }, {
                    "replacement", "" }
            };

            String[][] moveMousetoCell_replaceText1 = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoCell_replaceText" }, {
                    "path", "" }, {
                    "replaceText", "" }, {
                    "startIndex", "" }, {
                    "endIndex", "" }
            };

            String[][] setCellText = new String[][] { { "typ", "" }, {
                    "method", "setCellText" }, {
                    "path", "" }, {
                    "replacement", "" }
            };

            String[][] moveMousetoCell_setText = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoCell_setText" }, {
                    "path", "" }, {
                    "replacement", "" }
            };

            Hashtable xtextCompact = new Hashtable();
            xtextCompact.put("insertCellText", insertTexttoCell);
            xtextCompact.put("moveMouse insertCellText", moveMousetoCell_insertText);
            xtextCompact.put("deleteCellText", deleteCellText);
            xtextCompact.put("moveMouse deleteCellText", moveMousetoCell_deleteText);
            xtextCompact.put("replaceCellText with TEXT and REPLACEMENT", replaceCellText);
            xtextCompact.put("replaceCellText with STARTINDEX and ENDINDEX", replaceCellText1);
            xtextCompact.put("moveMouse replaceCellText with TEXT and REPLACEMENT", moveMousetoCell_replaceText);
            xtextCompact.put("moveMouse replaceCellText with STARTINDEX and ENDINDEX", moveMousetoCell_replaceText1);
            xtextCompact.put("setCellText", setCellText);
            xtextCompact.put("moveMouse setCellText", moveMousetoCell_setText);

            return xtextCompact;
        }
    }
}
