package com.sun.star.wizards.tutorial.executer.officeHelper;

import java.awt.event.KeyEvent;

import com.sun.star.accessibility.AccessibleRole;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.tutorial.executer.util.AccessibilityTools;
import com.sun.star.wizards.tutorial.executer.util.Helper;

/**
 * This class' purpose consists in the text processing functions.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public abstract class Components extends Desktop implements com.sun.star.wizards.tutorial.executer.officeHelper.XTextCompact, com.sun.star.wizards.tutorial.executer.officeHelper.XItemSelection {
    //*******************************************************************
    //                                                                  *
    //                      insert TEXT                                 *
    //                                                                  *
    //*******************************************************************

    /**
     * Insert text
     *
     * @param path child path
     * @param index index
     * @param insertText text
     */
    public void insertText(String[] path, int index, String insertText) {
        XAccessibleContext child = getXAccessibleContext(path);
        insertTextHelper(child, index, insertText);
    }

    /**
     * Move mouse accessibility object and insert text
     *
     * @param path child path
     * @param index index
     * @param insertText text
     */
    public void moveMousetoObject_insertText(String[] path, int index, String insertText) {
        XAccessibleContext child = getXAccessibleContext(path);
        moveMouse_Click(child);
        insertTextHelper(child, index, insertText);
    }

    //*******************************************************************
    //                                                                  *
    //                      delete TEXT                                 *
    //                                                                  *
    //*******************************************************************

    /**
     * Delete text To delete the whole text - startindex=0, endindex=-1
     *
     * @param path child path
     * @param startIndex index
     * @param endIndex index
     */
    public void deleteText(String[] path, int startIndex, int endIndex) {
        XAccessibleContext child = getXAccessibleContext(path);
        deleteTextHelper(child, startIndex, endIndex);
    }

    /**
     * Move mouse accessibility object and delete text To delete the whole text -
     * startindex=0, endindex=-1
     *
     * @param path child path
     * @param startIndex index
     * @param endIndex index
     */
    public void moveMousetoObject_deleteText(String[] path, int startIndex, int endIndex) {
        XAccessibleContext child = getXAccessibleContext(path);
        moveMouse_Click(child);
        deleteTextHelper(child, startIndex, endIndex);
    }

    //*******************************************************************
    //                                                                  *
    //                      replace TEXT                                *
    //                                                                  *
    //*******************************************************************

    /**
     * Replace text.
     *
     * @param path child path
     * @param text text
     * @param replacement text
     */
    public void replaceText(String[] path, String text, String replacement) {
        XAccessibleContext child = getXAccessibleContext(path);
        replaceHelper(child, text, replacement);
    }

    /**
     * Replace text. To replace the whole text - startindex=0, endindex=-1
     *
     * @param path child path
     * @param replacement text
     * @param startIndex index
     * @param endIndex index
     */
    public void replaceText(String[] path, String replacement, int startIndex, int endIndex) {
        XAccessibleContext child = getXAccessibleContext(path);
        replaceHelper(child, startIndex, endIndex, replacement);
    }

    /**
     * Move mouse to accessibility object and replace text.
     *
     * @param path child path
     * @param text text
     * @param replacement text
     */
    public void moveMousetoObject_replaceText(String[] path, String text, String replacement) {
        XAccessibleContext child = getXAccessibleContext(path);
        moveMouse_Click(child);
        replaceHelper(child, text, replacement);
    }

    /**
     * Move mouse to accessibility object and replace text. To replace the whole text -
     * startindex=0, endindex=-1
     *
     * @param path child path
     * @param replacement text
     * @param startIndex index
     * @param endIndex index
     */
    public void moveMousetoObject_replaceText(String[] path, String replacement, int startIndex, int endIndex) {
        XAccessibleContext child = getXAccessibleContext(path);
        moveMouse_Click(child);
        replaceHelper(child, startIndex, endIndex, replacement);
    }

    //*******************************************************************
    //                                                                  *
    //                         set TEXT                                 *
    //                                                                  *
    //*******************************************************************

    /**
     * Set text.
     *
     * @param path child path
     * @param replacement text
     */
    public void setText(String[] path, String replacement) {
        XAccessibleContext child = getXAccessibleContext(path);
        replaceHelper(child, 0, -1, replacement);
    }

    /**
     * Move mouse to accessibility object and set text.
     *
     * @param path child path
     * @param replacement text
     */
    public void moveMousetoObject_setText(String[] path, String replacement) {
        XAccessibleContext child = getXAccessibleContext(path);
        moveMouse_Click(child);
        replaceHelper(child, 0, -1, replacement);
    }

    //*******************************************************************
    //                                                                  *
    //                      select TEXT                                 *
    //                                                                  *
    //*******************************************************************

    /**
     * Select accessibility object. To select the whole text - startindex=0, endindex=-1
     *
     * @param path child path
     * @param selectText text
     */
    public void selectText(String[] path, String selectText) {
        XAccessibleContext child = getXAccessibleContext(path);
        selectHelper(child, selectText);
    }

    /**
     * Select accessibility object. To select the whole text - startindex=0, endindex=-1
     *
     * @param path child path
     * @param startIndex index
     * @param endIndex index
     */
    public void selectText(String[] path, int startIndex, int endIndex) {
        XAccessibleContext child = getXAccessibleContext(path);
        selectHelper(child, startIndex, endIndex);
    }

    /**
     * Move mouse to accessibility object and select object. To select the whole text -
     * startindex=0, endindex=-1
     *
     * @param path child path
     * @param startIndex index
     * @param endIndex index
     */
    public void moveMousetoObject_selectText(String[] path, int startIndex, int endIndex) {
        XAccessibleContext child = getXAccessibleContext(path);
        moveMouse_Click(child);
        selectHelper(child, startIndex, endIndex);
    }

    /**
     * Move mouse to accessibility object and select object.
     *
     * @param path child path
     * @param selectText text
     */
    public void moveMousetoObject_selectText(String[] path, String selectText) {
        XAccessibleContext child = getXAccessibleContext(path);
        moveMouse_Click(child);
        selectHelper(child, selectText);
    }

    //*******************************************************************
    //                                                                  *
    //                      Page tab                                    *
    //                                                                  *
    //*******************************************************************

    /**
     * Set Accessibility child tab.
     *
     * @param path child path
     * @param index child index
     * @param sleep to change tab in millisecunds
     */
    public void setTab(String[] path, int index, int sleep) {
        try {
            XAccessibleContext child = getXAccessibleContext(path);

            if (child != null) {
                XAccessibleSelection selection = AccessibilityTools.getXAccessibleSelection(child);
                int count = child.getAccessibleChildCount();

                if ((index > -1) && (index < count)) {
                    if (!selection.isAccessibleChildSelected(index)) {
                        int selected = 0;

                        for (int i = 0; i < count; i++) {
                            if (selection.isAccessibleChildSelected(i)) {
                                selected = i;

                                break;
                            }
                        }

                        if (index > selected) {
                            for (int i = selected; index >= i; i++) {
                                selection.selectAccessibleChild(i);
                                sleep(sleep);
                            }
                        } else {
                            //index < selected
                            for (int i = selected; index <= i; i--) {
                                selection.selectAccessibleChild(i);
                                sleep(sleep);
                            }
                        }
                    }
                }
            }
        } catch (java.lang.Exception ex) {
        }
    }

    //*******************************************************************
    //                                                                  *
    //                      Combo Box Item selection                    *
    //                                                                  *
    //*******************************************************************

    /**
     * Select Accessibility child (combo box item selection).
     *
     * @param path child path
     * @param index child index
     */
    public void selectItem_Index(String[] path, int index) {
        try {
            XAccessibleContext child = getXAccessibleContext(path); //getXAccessibleforList(path);

            if (child != null) {
                XAccessibleSelection selection = null;
                XAccessibleContext xaccCon = null;

                Helper.log("ImpName    :" + AccessibilityTools.getImplName(child));
                Helper.log("Childcount :" + child.getAccessibleChildCount());

                if (AccessibilityTools.getImplName(child).indexOf("AccessibleTreeListBox") > -1) {
                    selection = AccessibilityTools.getXAccessibleSelection(child);
                } else {
                    if (AccessibilityTools.getImplName(child).indexOf("AccessibleToolBox") > -1) {
                        for (int i = 0;(i < child.getAccessibleChildCount()) && (xaccCon == null); i++) {
                            xaccCon = getSelectionContext(child.getAccessibleChild(i).getAccessibleContext());
                        }
                    } else {
                        xaccCon = getSelectionContext(child);
                    }

                    if (xaccCon != null) {
                        selection = AccessibilityTools.getXAccessibleSelection(xaccCon);
                    }
                }

                if ((index > -1) && (selection != null)) {
                    selection.selectAccessibleChild(index);
                }
            }
        } catch (java.lang.Exception ex) {
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param child DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws Exception DOCUMENT ME!
     */
    private XAccessibleContext getSelectionContext(XAccessibleContext child) throws Exception {
        XAccessibleContext xaccCon = null;

        for (int i = 0; i < child.getAccessibleChildCount(); i++) {
            XAccessibleContext tempCon = child.getAccessibleChild(i).getAccessibleContext();
            String impName = AccessibilityTools.getImplName(tempCon);
            Helper.log("ChildImpName    :" + impName);
            Helper.log("ChildChildcount :" + tempCon.getAccessibleChildCount());

            if ((impName.indexOf("AccessibleList") > -1) && (tempCon.getAccessibleChildCount() > -1)) {
                xaccCon = tempCon;

                break;
            }
        }

        return xaccCon;
    }

    /**
     * Select Accessibility child.
     *
     * @param path child path
     * @param name child name
     */
    public void selectItem_Name(String[] path, String name) {
        try {
            XAccessibleContext child = null;
            XAccessibleContext childItem = null;
            XAccessibleSelection selection = null;
            short role = -1;
            String[] cPath = checkPath(path);

            if (cPath == null) {
                child = getXAccessibleContext(path);
            } else {
                child = getXAccessibleContext(cPath);
            }

            if (child != null) {
                if (AccessibilityTools.getImplName(child).indexOf("AccessibleTreeListBox") > -1) {
                    selection = AccessibilityTools.getXAccessibleSelection(child);
                    role = AccessibleRole.LABEL;
                } else {
                    for (int i = 0; i < child.getAccessibleChildCount(); i++) {
                        XAccessibleContext xaccCon = child.getAccessibleChild(i).getAccessibleContext();
                        String impName = AccessibilityTools.getImplName(xaccCon);

                        childItem = AccessibilityTools.getXAccessibleContext(xaccCon, AccessibleRole.LIST_ITEM, name);

                        if (childItem != null) {
                            selection = AccessibilityTools.getXAccessibleSelection(childItem.getAccessibleParent().getAccessibleContext());
                            selection.selectAccessibleChild(childItem.getAccessibleIndexInParent());

                            return;
                        }
                    }
                }
            }
        } catch (java.lang.Exception ex) {
        }
    }

    /**
     * Check Accessibility child path of COMBO_BOX
     *
     * @param path child path
     *
     * @return Fix accessibility child path
     */
    private String[] checkPath(String[] path) {
        String[] pathCopy = null;

        for (int i = path.length - 1; -1 < i; i--) {
            String identify = path[i].trim();
            String[] idents = identify.split("#", 3);

            if (idents.length == 3) {
                String sRole = idents[0].trim();
                String sName = idents[1].trim();

                if (sRole.equals("COMBO_BOX") && sName.equals("")) {
                    int copySize = 1;

                    if (i > 0) {
                        copySize = i;
                    }

                    pathCopy = new String[copySize];

                    for (int j = 0; j < copySize; j++) {
                        pathCopy[j] = path[j];
                    }

                    break;
                }
            }
        }

        return pathCopy;
    }

    //*******************************************************************
    //                                                                  *
    //                      private                                     *
    //                                                                  *
    //*******************************************************************
    private XAccessibleContext checkAccessibleObject(XInterface child) {
        XAccessibleContext context = AccessibilityTools.getXAccessibleContext(child);

        if ((context != null) && (AccessibilityTools.getImplName(context).indexOf("AccessibleList") > -1)) {
            String impName = AccessibilityTools.getImplName(context);

            XAccessibleContext parentContext = context.getAccessibleParent().getAccessibleContext();

            try {
                for (int i = 0; i < parentContext.getAccessibleChildCount(); i++) {
                    XAccessible xaccesTemp = parentContext.getAccessibleChild(i);
                    XAccessibleContext xaccCon = xaccesTemp.getAccessibleContext();
                    impName = AccessibilityTools.getImplName(xaccCon);

                    if ((impName.indexOf("AccessibleEdit") > -1)) {
                        context = xaccCon;

                        break;
                    }
                }
            } catch (IndexOutOfBoundsException ex) {
            }
        }

        return context;
    }

    /**
     * Insert text helper
     *
     * @param child child
     * @param index index
     * @param insertText text
     */
    private void insertTextHelper(XInterface child, int index, String insertText) {
        XAccessibleContext context = checkAccessibleObject(child);

        if (context != null) {
            XAccessibleText xacclText = AccessibilityTools.getAccessibleTextObject(context);
            int movePosition = index;

            if (xacclText != null) {
                String text = xacclText.getText();

                if (text != null) {
                    if (movePosition == -1) {
                        movePosition = text.length();
                    }

                    moveCursorPostion(xacclText.getCaretPosition(), movePosition, text.length());
                }
            }

            insertText(context, movePosition, insertText);
        }
    }

    /**
     * Insert text
     *
     * @param child child
     * @param movePosition move position
     * @param insertText
     */
    private void insertText(XInterface child, int movePosition, String insertText) {
        XAccessibleEditableText xacclEditText = AccessibilityTools.getAccessibleEditableTextObject(child);

        if ((xacclEditText != null) && (insertText != null) && (insertText.length() > 0) && (movePosition > -1)) {
            int leng = insertText.length();

            try {
                for (int i = movePosition, j = 0; j < leng; i++, j++) {
                    xacclEditText.insertText(("" + insertText.charAt(j)), i);
                    sleep(getKeyDelay());
                }
            } catch (com.sun.star.lang.IndexOutOfBoundsException e) {
                Helper.log("Couldn't get Child");
            }
        }
    }

    /**
     * Delete text helper. To delete the whole text - startindex=0, endindex=-1
     *
     * @param child child
     * @param startIndex index
     * @param endIndex index!
     */
    private void deleteTextHelper(XInterface child, int startIndex, int endIndex) {
        XAccessibleContext context = checkAccessibleObject(child);

        if (context != null) {
            XAccessibleText xacclText = AccessibilityTools.getAccessibleTextObject(context);

            if (xacclText != null) {
                String text = xacclText.getText();

                if (text != null) {
                    int movePosition = endIndex;

                    if (movePosition == -1) {
                        movePosition = text.length();
                    }

                    moveCursorPostion(xacclText.getCaretPosition(), movePosition, text.length());
                    deleteText(context, startIndex, movePosition);
                }
            }
        }
    }

    /**
     * Delete text. To delete the whole text - startindex=0, endindex=-1
     *
     * @param child child
     * @param startIndex index
     * @param endIndex index
     */
    private void deleteText(XInterface child, int startIndex, int endIndex) {
        XAccessibleEditableText xacclEditText = AccessibilityTools.getAccessibleEditableTextObject(child);

        if ((xacclEditText != null) && (startIndex > -1) && (endIndex > startIndex)) {
            int endStartDist = endIndex - startIndex;

            try {
                for (int i = endStartDist; i > 0; i--) {
                    xacclEditText.deleteText(startIndex + (i - 1), startIndex + i);
                    sleep(getKeyDelay());
                }
            } catch (com.sun.star.lang.IndexOutOfBoundsException e) {
                Helper.log("Couldn't get Child");
            }
        }
    }

    /**
     * Replace text helper. To replace the whole text - startindex=0, endindex=-1
     *
     * @param child child
     * @param startIndex index
     * @param endIndex index
     * @param insertText text
     */
    private void replaceHelper(XInterface child, int startIndex, int endIndex, String insertText) {
        deleteTextHelper(child, startIndex, endIndex);
        insertTextHelper(child, startIndex, insertText);
    }

    /**
     * Replace text helper
     *
     * @param child child
     * @param searchText text
     * @param insertText text
     */
    private void replaceHelper(XInterface child, String searchText, String insertText) {
        XAccessibleContext context = checkAccessibleObject(child);

        if (context != null) {
            XAccessibleText xacclText = AccessibilityTools.getAccessibleTextObject(context);

            if (xacclText != null) {
                String text = xacclText.getText();

                if ((text != null) && (searchText != null) && !(searchText.equals(""))) {
                    int movePosition = text.length();
                    int index = text.indexOf(searchText);
                    movePosition = index + searchText.length();
                    moveCursorPostion(xacclText.getCaretPosition(), movePosition, text.length());
                    deleteText(context, index, movePosition);
                    insertText(context, index, insertText);
                }
            }
        }
    }

    /**
     * Select text helper To select the whole text - startindex=0, endindex=-1
     *
     * @param child child
     * @param startIndex index
     * @param endIndex index
     */
    private void selectHelper(XInterface child, int startIndex, int endIndex) {
        XAccessibleContext context = checkAccessibleObject(child);

        if (context != null) {
            XAccessibleText xacclText = AccessibilityTools.getAccessibleTextObject(context);

            if (xacclText != null) {
                String text = xacclText.getText();

                if ((text != null) && (endIndex < text.length())) {
                    if (endIndex == -1) {
                        endIndex = text.length();
                    }

                    if ((startIndex > -1) && (startIndex < endIndex)) {
                        moveCursorPostion(xacclText.getCaretPosition(), startIndex, text.length());

                        try {
                            xacclText.setSelection(startIndex, endIndex);
                        } catch (com.sun.star.lang.IndexOutOfBoundsException ioobx) {
                        }
                    }
                }
            }
        }
    }

    /**
     * Select text helper
     *
     * @param child child
     * @param description text
     */
    private void selectHelper(XInterface child, String description) {
        XAccessibleContext context = checkAccessibleObject(child);

        if (context != null) {
            XAccessibleText xacclText = AccessibilityTools.getAccessibleTextObject(context);

            if (xacclText != null) {
                String text = xacclText.getText();

                if (text != null) {
                    if ((description != null) && !(description.equals(""))) {
                        int startIndex = text.indexOf(description);
                        int endIndex = startIndex + description.length();

                        if ((startIndex > -1) && (startIndex < endIndex)) {
                            moveCursorPostion(xacclText.getCaretPosition(), startIndex, text.length());

                            try {
                                if ((startIndex > -1) && (startIndex < endIndex)) {
                                    xacclText.setSelection(startIndex, endIndex);
                                }
                            } catch (com.sun.star.lang.IndexOutOfBoundsException ioobx) {
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * Move cursor position. Use the standard java key events VK_LEFT and VK_RIGHT.
     *
     * @param currentPosition cursor position
     * @param movePosition position
     * @param textLength length
     */
    private void moveCursorPostion(int currentPosition, int movePosition, int textLength) {
        if (currentPosition > -1) {
            if (currentPosition < movePosition) {
                for (int i = currentPosition; i < movePosition; i++) {
                    if (i >= textLength) {
                        key_Press_Release(KeyEvent.VK_SPACE);
                    } else {
                        key_Press_Release(KeyEvent.VK_RIGHT);
                    }
                }
            } else if (currentPosition > movePosition) {
                for (int i = currentPosition; i > movePosition; i--) {
                    key_Press_Release(KeyEvent.VK_LEFT);
                }
            }
        }
    }
}
