/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: isbxobj.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/19 16:12:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define ITEMID_TABSTOP 0
#define _SVX_ISBXOBJ_CXX

#ifndef _SFX_SHELL_HXX //autogen
#include <sfx2/shell.hxx>
#endif

#ifndef _SFXMSG_HXX //autogen
#include <sfx2/msg.hxx>
#endif

#ifndef _SBXCLASS_HXX //autogen
#include <basic/sbx.hxx>
#endif
#include "svxids.hrc"
#include "isbxobj.hxx"

//-------------------------------------------------------------------------

#define TabStops
#include "svxslots.hrc"

//-------------------------------------------------------------------------

TYPEINIT1(SvxTabStopObject_Impl,SvDispatch);

// =======================================================================

SvxTabStopObject_Impl::SvxTabStopObject_Impl()
:	SvDispatch( "TabStops", SO2_TYPELIB_INFO(TabStops) ),
	pTabs( new SvxTabStopItem )
{
}

//------------------------------------------------------------------------


SvxTabStopObject_Impl::SvxTabStopObject_Impl( SbxVariable *pVar,
											  const SvxTabStopItem &rTabs )
:	SvDispatch( "TabStops", SO2_TYPELIB_INFO(TabStops) ),
	pTabs( (SvxTabStopItem*) rTabs.Clone() ),
	xVar( pVar )
{
}

//------------------------------------------------------------------------


SvxTabStopObject_Impl::~SvxTabStopObject_Impl()
{
	delete pTabs;
}

// -----------------------------------------------------------------------


void SvxTabStopObject_Impl::SFX_NOTIFY
(
	SfxBroadcaster& rBC, const TypeId& rBCType,
	const SfxHint& rHint, const TypeId& rHintType
)

/*	[Beschreibung]

	Wenn eine Metode gerufen wird, verschickt das Sbx-System einen Broadcast.
	Dieser kommt hier an, so da\s hier das Ausf"uhren der Methoden initiiert
	wird.
*/

{
	// Hint aufbereiten
	const SbxHint* pHint = PTR_CAST(SbxHint, &rHint);

	if ( !pHint )
	{
		// kein SbxHint => Basisklasse rufen und raus
		SvDispatch::SFX_NOTIFY( rBC, rBCType, rHint, rHintType );
		return;
	}
	ULONG nHint = pHint ? pHint->GetId() : 0;
	SbxVariable* pVar = pHint->GetVar();
	USHORT nSID = (USHORT)( pVar->GetUserData() & 0xFFFFL );
	BOOL bDone = FALSE;

	// Call einer Methode?
	if ( nHint == SBX_HINT_DATAWANTED && pVar->GetClass() == SbxCLASS_METHOD )
	{
		// Parameterarray bereitstellen
		SbxArrayRef xPar = pVar->GetParameters();
		if ( !xPar.Is() )
			xPar = new SbxArray;

		// Insert-Methode?
		if ( nSID == SID_TAB_INSERT )
		{
			// Parameteranzahl pr"ufen
			if ( xPar->Count() < 2 )
				SetError( SbxERR_WRONG_ARGS );

			// Parameter auswerten
			long nPos = xPar->Get(1)->GetLong();
			SvxTabAdjust eAdjust = SVX_TAB_ADJUST_LEFT;
			if ( xPar->Count() > 2 )
			{
				switch ( xPar->Get(2)->GetString()[ (USHORT) 0] )
				{
					case 'L':
					case 'l':
						eAdjust = SVX_TAB_ADJUST_LEFT;
						break;

					case 'R':
					case 'r':
						eAdjust = SVX_TAB_ADJUST_RIGHT;
						break;

					case 'C':
					case 'c':
						eAdjust = SVX_TAB_ADJUST_CENTER;
						break;

					case 'D':
					case 'd':
						eAdjust = SVX_TAB_ADJUST_DECIMAL;
						break;
				}
			}
			unsigned char cDec =
					xPar->Count() > 3 ? xPar->Get(3)->GetString()[(USHORT)0] : ',';
			unsigned char cFill =
					xPar->Count() > 4 ? xPar->Get(4)->GetString()[(USHORT)0] : ' ';
			pTabs->Insert( SvxTabStop( nPos, eAdjust, cDec, cFill ) );
			bDone = TRUE;
		}
		else if ( nSID == SID_TAB_REMOVE )
		{
			// Parameteranzahl pr"ufen
			if ( xPar->Count() < 1 )
				SetError( SbxERR_WRONG_ARGS );

			long nPos = xPar->Get(1)->GetLong();
			USHORT nIdxPos = pTabs->GetPos(nPos);
			if( nIdxPos != SVX_TAB_NOTFOUND)
			{
				pTabs->Remove(nIdxPos);
				bDone = TRUE;
			}
		}
		else if ( nSID == SID_TAB_REMOVE_BY_INDEX )
		{
			// Parameteranzahl pr"ufen
			if ( xPar->Count() < 1 )
				SetError( SbxERR_WRONG_ARGS );

			long nPos = xPar->Get(1)->GetLong();

			if ( nPos < pTabs->Count() )
			{
				pTabs->Remove( (USHORT)nPos );
				bDone = TRUE;
			}
		}
		else if ( nSID == SID_TAB_REMOVE_ALL )
		{
			USHORT nCount = pTabs->Count();
			if(nCount)
				pTabs->Remove(0, nCount);
			bDone = TRUE;
		}
		// alle anderen Methoden haben denselben Aufbau
		else
		{
			// Parameter holen und pr"ufen
			if ( xPar->Count() != 2 )
				{ SetError( SbxERR_WRONG_ARGS ); return; }
			short nNo = xPar->Get(1)->GetInteger();
			if ( nNo > pTabs->Count() )
				{ SetError( SbxERR_BAD_INDEX ); return; }

			// Tabulatoren indizieren
			const SvxTabStop &rTab = pTabs->GetObject( nNo );

			// Returnwerte setzen
			switch ( nSID )
			{
				// GetPosition
				case SID_TAB_POSITION:
					pVar->PutLong( rTab.GetTabPos() );
					bDone = TRUE;
					break;

				// bGetAdjust
				case SID_TAB_ADJUST:
					pVar->PutString( GetAdjustChar( rTab.GetAdjustment() ) );
					bDone = TRUE;
					break;

				// GetDecimal
				case SID_TAB_DECIMAL:
					pVar->PutString( rTab.GetDecimal() );
					bDone = TRUE;
					break;

				// GetFillChar
				case SID_TAB_FILLCHAR:
					pVar->PutString( rTab.GetFill() );
					bDone = TRUE;
					break;
			}
		}

		// Auto-Writeback f"ur Pseudo-Referenzen
		if ( bDone && xVar.Is() )
			xVar->PutObject( this );
	}

	// Property lesen?
	else if ( nHint == SBX_HINT_DATAWANTED &&
			  pVar->GetClass() == SbxCLASS_PROPERTY )
	{
		// Count-Property?
		if ( nSID == SID_TAB_COUNT )
		{
			// Returnwert setzen
			pVar->PutLong( pTabs->Count() );
			bDone = TRUE;
		}
	}

	// ggf. Basisklasse rufen
	if ( !bDone )
		SvDispatch::SFX_NOTIFY( rBC, rBCType, rHint, rHintType );
}

// -----------------------------------------------------------------------


String SvxTabStopObject_Impl::GenerateSource
(
	const String &rLinePrefix,
	const SbxObject *pRelativeTo
)

/*	[Beschreibung]

	Mit dieser Methode wird ein String erzeugt, der den Source-Code enth"lt,
	mit dem das Objekt wiederhergestellt werden kann. Dabei ist das Objekt
	als aktiver Kontext bereitgestellt (WITH-Statement), auf Methoden und
	Properties des Objektes kann daher direkt zugegriffen werden.
*/

{
	// je TabStop ein Insert-Statement erzeugen
	String aSource;
	FASTBOOL bLineFeed = FALSE;
	for ( USHORT nTab = 0; nTab < pTabs->Count(); ++nTab )
	{
		// keine Default-Tabs recorden
		const SvxTabStop &rTabStop = pTabs->GetObject(nTab);
		if ( SVX_TAB_ADJUST_DEFAULT == rTabStop.GetAdjustment() )
			continue;

		// ausser vor dem ersten Statement immer einen Umbruch einfuegen
		if ( bLineFeed )
			aSource += '\n';
		else
			bLineFeed = TRUE;

		// Statement schreiben
		aSource += rLinePrefix;
		aSource += ".Insert( ";

		// Parameter schreiben
		aSource += rTabStop.GetTabPos();
		aSource += ", \"";
		aSource += GetAdjustChar( rTabStop.GetAdjustment() );
		aSource += "\", \"";
		aSource += (char) rTabStop.GetDecimal();
		aSource += "\", \"";
		aSource += (char) rTabStop.GetFill();
		aSource += "\" )";
	}
	return aSource;

}

// -----------------------------------------------------------------------

char SvxTabStopObject_Impl::GetAdjustChar( SvxTabAdjust eAdj )

/*	[Beschreibung]

	Hilfsmethode zum umwandeln des Enum-Wertes SvxTabAdjust in
	ein Character;
*/

{
	switch ( eAdj )
	{
		case SVX_TAB_ADJUST_LEFT:	return 'L';
		case SVX_TAB_ADJUST_RIGHT:	return 'R';
		case SVX_TAB_ADJUST_DECIMAL:return 'D';
		case SVX_TAB_ADJUST_CENTER: return 'C';
	}

	return ' ';
}



