/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: desktopbecdef.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ihi $ $Date: 2006/08/04 12:28:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_CONFIGURATION_BACKEND_XSCHEMASUPPLIER_HPP_
#include <com/sun/star/configuration/backend/XSingleLayerStratum.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

#ifndef _CPPUHELPER_IMPLEMENTATIONENTRY_HXX_
#include <cppuhelper/implementationentry.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_XCOMPONENTCONTEXT_HPP_
#include <com/sun/star/uno/XComponentContext.hpp>
#endif

#include "uno/current_context.hxx"

namespace css = com::sun::star ;
namespace uno = css::uno ;
namespace lang = css::lang ;
namespace backend = css::configuration::backend ;

//==============================================================================

static uno::Reference<uno::XInterface> SAL_CALL createDesktopBackend(const uno::Reference<uno::XComponentContext>& xContext)
{
    try {
        uno::Reference< uno::XCurrentContext > xCurrentContext(uno::getCurrentContext());
        
        if (xCurrentContext.is())
        {
            uno::Any aValue = xCurrentContext->getValueByName(
                rtl::OUString::createFromAscii( "system.desktop-environment" ) );
        
            rtl::OUString aDesktopEnvironment;
            if ( aValue >>= aDesktopEnvironment )
            {
                rtl::OUString aDesktopService;
                if ( aDesktopEnvironment.equalsIgnoreAsciiCaseAscii( "gnome" ) )
                    aDesktopService = rtl::OUString::createFromAscii( "com.sun.star.configuration.backend.GconfBackend" );
                else if ( aDesktopEnvironment.equalsIgnoreAsciiCaseAscii( "kde" ) )
                    aDesktopService = rtl::OUString::createFromAscii( "com.sun.star.configuration.backend.KDEBackend" );
                else
                    return uno::Reference<uno::XInterface>(); 

                uno::Reference< lang::XMultiComponentFactory > xServiceManager = xContext->getServiceManager();
                if( xServiceManager.is() )
                {
                    return uno::Reference< backend::XSingleLayerStratum >::query(
                            xServiceManager->createInstanceWithContext( aDesktopService, xContext) );
                }
            }
        }
    } catch (uno::RuntimeException e) {
    }    

    return uno::Reference<uno::XInterface>(); 
}

static rtl::OUString SAL_CALL getBackendName(void) {
    return rtl::OUString( 
        RTL_CONSTASCII_USTRINGPARAM("com.sun.star.comp.configuration.backend.DesktopBackend") );
}

static uno::Sequence<rtl::OUString> SAL_CALL getBackendServiceNames(void) 
{
    uno::Sequence<rtl::OUString> aServices(2) ;
    aServices[0] = rtl::OUString( 
        RTL_CONSTASCII_USTRINGPARAM("com.sun.star.configuration.backend.DesktopBackend")) ;
    aServices[1] = rtl::OUString( 
        RTL_CONSTASCII_USTRINGPARAM("com.sun.star.configuration.backend.PlatformBackend")) ;

    return aServices ;
}

static uno::Sequence<rtl::OUString> SAL_CALL getSupportedComponents(void)
{
    const sal_Int32 nComponents = 7;

    uno::Sequence<rtl::OUString> aSupportedComponentsList(nComponents) ;

    aSupportedComponentsList[0] = rtl::OUString( 
        RTL_CONSTASCII_USTRINGPARAM("org.openoffice.VCL")) ;
    aSupportedComponentsList[1] = rtl::OUString( 
        RTL_CONSTASCII_USTRINGPARAM("org.openoffice.Inet")) ;
    aSupportedComponentsList[2] = rtl::OUString( 
        RTL_CONSTASCII_USTRINGPARAM("org.openoffice.Office.Common")) ;
    aSupportedComponentsList[3] = rtl::OUString( 
        RTL_CONSTASCII_USTRINGPARAM("org.openoffice.Office.Paths")) ;

    aSupportedComponentsList[4] = rtl::OUString( 
        RTL_CONSTASCII_USTRINGPARAM("org.openoffice.UserProfile")) ;
    aSupportedComponentsList[5] = rtl::OUString( 
        RTL_CONSTASCII_USTRINGPARAM("org.openoffice.Office.Recovery")) ;
    aSupportedComponentsList[6] = rtl::OUString( 
        RTL_CONSTASCII_USTRINGPARAM("org.openoffice.Setup")) ;

    return aSupportedComponentsList ;
}
//==============================================================================

static const cppu::ImplementationEntry kImplementations_entries[] = 
{
    {
        createDesktopBackend,
        getBackendName,
        getBackendServiceNames,
        cppu::createSingleComponentFactory,
        NULL,
        0
    },
    { NULL, NULL, NULL, NULL, NULL, 0 }
} ;
//------------------------------------------------------------------------------

extern "C" void SAL_CALL component_getImplementationEnvironment(
                                            const sal_Char **aEnvTypeName,
                                            uno_Environment ** /* aEnvironment */)
{
    *aEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME ;
}

//------------------------------------------------------------------------------

extern "C" sal_Bool SAL_CALL component_writeInfo(void * /* pServiceManager */,
                                                 void *pRegistryKey)
{
    using namespace ::com::sun::star::registry;
    if (pRegistryKey)
    {
        try
        {
            uno::Reference< XRegistryKey > xImplKey = static_cast< XRegistryKey* >( pRegistryKey )->createKey(
                rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("/") ) + getBackendName()
            );
            
            // Register associated service names
            uno::Reference< XRegistryKey > xServicesKey = xImplKey->createKey( 
                rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("/UNO/SERVICES") )
            );
            
            uno::Sequence<rtl::OUString> sServiceNames = getBackendServiceNames();
            for (sal_Int32 i = 0 ; i < sServiceNames.getLength() ; ++ i)
                xServicesKey->createKey(sServiceNames[i]);

            // Register supported components            
            uno::Reference<XRegistryKey> xComponentKey = xImplKey->createKey(
                rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("/DATA/SupportedComponents") )
            );
        
            xComponentKey->setAsciiListValue( getSupportedComponents() );

            return sal_True;
        }
        
        catch( InvalidRegistryException& )
        {                       
            OSL_ENSURE(sal_False, "InvalidRegistryException caught");           
        }
    }
    
    return sal_False;
}

//------------------------------------------------------------------------------

extern "C" void *component_getFactory(const sal_Char *aImplementationName,
                                      void *aServiceManager,
                                      void *aRegistryKey)
{
    return cppu::component_getFactoryHelper(
        aImplementationName,
        aServiceManager,
        aRegistryKey,
        kImplementations_entries) ;
}
//------------------------------------------------------------------------------
