/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dlgepbm.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/19 21:41:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef GCC
#pragma hdrstop
#endif

#include <tools/ref.hxx>
#include <svtools/FilterConfigItem.hxx>
#include <vcl/msgbox.hxx>
#include "dlgepbm.hxx"
#include "dlgepbm.hrc"
#include "strings.hrc"

/*************************************************************************
|*
|* Ctor
|*
\************************************************************************/

DlgExportEPBM::DlgExportEPBM( FltCallDialogParameter& rPara ) :
				ModalDialog			( rPara.pWindow, ResId( DLG_EXPORT_EPBM, rPara.pResMgr ) ),
				rFltCallPara		( rPara ),
				aGrpFormat			( this, ResId( GRP_FORMAT ) ),
				aRBRaw				( this, ResId( RB_RAW ) ),
				aRBASCII			( this, ResId( RB_ASCII ) ),
				aBtnOK				( this, ResId( BTN_OK ) ),
				aBtnCancel			( this, ResId( BTN_CANCEL ) ),
				aBtnHelp			( this, ResId( BTN_HELP ) ),
				pMgr				( rPara.pResMgr )
{
	FreeResource();

	// Config-Parameter lesen

	String	aFilterConfigPath( RTL_CONSTASCII_USTRINGPARAM( "Office.Common/Filter/Graphic/Export/PBM" ) );
	pConfigItem = new FilterConfigItem( aFilterConfigPath, &rPara.aFilterData );
	sal_Int32	nFormat = pConfigItem->ReadInt32( String( ResId( KEY_FORMAT, pMgr ) ), 1 );

	BOOL bCheck = FALSE;
	if ( !nFormat )
		bCheck ^= TRUE;

	aRBRaw.Check( bCheck );
	bCheck ^= TRUE;
	aRBASCII.Check( bCheck );

	aBtnOK.SetClickHdl( LINK( this, DlgExportEPBM, OK ) );
}

DlgExportEPBM::~DlgExportEPBM()
{
	delete pConfigItem;
}

/*************************************************************************
|*
|* Speichert eingestellte Werte in ini-Datei
|*
\************************************************************************/

IMPL_LINK( DlgExportEPBM, OK, void *, EMPTYARG )
{

	// Config-Parameter schreiben
	sal_Int32 nFormat = 0;
	if ( aRBASCII.IsChecked() )
		nFormat++;
	pConfigItem->WriteInt32( String( ResId( KEY_FORMAT, pMgr ) ), nFormat );
	rFltCallPara.aFilterData = pConfigItem->GetFilterData();
	EndDialog( RET_OK );

	return 0;
}
