/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: groupnodeaccess.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:17:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "groupnodeaccess.hxx"

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

// -----------------------------------------------------------------------------	

namespace configmgr
{
// -----------------------------------------------------------------------------	
    namespace data
    {
    // -------------------------------------------------------------------------
        using memory::Pointer;
    // -------------------------------------------------------------------------
    // -------------------------------------------------------------------------

        Pointer GroupNodeAccess::check(Accessor const& _aAccessor, sharable::GroupNode const* pInnerNode)
        {
            return _aAccessor.address(pInnerNode);      
        }
    // -------------------------------------------------------------------------

        Pointer GroupNodeAccess::check(NodeAccessRef const& _aNode)
        {
            if (sharable::Node const* pNode = _aNode.getDataPtr())
                return check(_aNode.accessor(), pNode->groupData());

            else
                return Pointer();
        }
    // -------------------------------------------------------------------------
        bool GroupNodeAccess::hasChildren() const
        {
            using namespace sharable;
            GroupNode const  & aNode = data();
            return aNode.numDescendants > 0 ? true:false;
        }


    // -------------------------------------------------------------------------

        NodeAddress GroupNodeAccess::implGetChild(Name const& _aName) const
        {
            using namespace sharable;
            GroupNode const  & aNode = data();
            for (Node const * pChild = aNode.getFirstChild();
                              pChild != NULL;
                              pChild = aNode.getNextChild(pChild))
            {
                if (pChild->isNamed(_aName.toString(), m_aAccessor))
                {
                    NodeAccessRef aChildNode(&m_aAccessor,pChild);
                    return aChildNode.address();
                }            
            }
            return NodeAddress();
        }

    // -------------------------------------------------------------------------*/
    // -------------------------------------------------------------------------*/

    }
// -----------------------------------------------------------------------------	
} // namespace configmgr


