/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DoubleRectangle.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:47:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "DoubleRectangle.hxx"

#include <vector>

//.............................................................................
namespace chart
{
//.............................................................................
using namespace ::com::sun::star;

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

DoublePoint DoublePoint::operator-( const DoublePoint& rP )
{
    DoublePoint aRet;
    aRet.X = this->X - rP.X;
    aRet.Y = this->Y - rP.Y;
    return aRet;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

DoubleRectangle::DoubleRectangle( double fLeft, double fTop, double fRight, double fBottom )
        : Left(fLeft), Top(fTop), Right(fRight), Bottom(fBottom)
{
    init();
}
DoubleRectangle::DoubleRectangle( const awt::Point& rPos, const awt::Size& rSize )
        : Left(rPos.X), Top(rPos.Y), Right(Left+rSize.Width), Bottom(Top+rSize.Height)
{
    init();
}
void DoubleRectangle::init()
{
    //values grow to right
    //and grow to bottom
    if(Left>Right)
    {
        double fHelp = Right;
        Right = Left;
        Left = fHelp; 
    }
    if(Top>Bottom)
    {
        double fHelp = Bottom;
        Bottom = Top;
        Top = fHelp;
    }
}

bool DoubleRectangle::isInside( const DoublePoint& rP ) const
{
    if(rP.X<Left)
        return false;
    if(rP.X>Right)
        return false;
    if(rP.Y<Bottom)
        return false;
    if(rP.Y>Top)
        return false;
    return true;
}

bool DoubleRectangle::isOverlap( const DoubleRectangle& rRect ) const
{
    double fLeft = ::std::max(Left,rRect.Left);
    double fTop = ::std::max(Top,rRect.Top);
    double fRight = ::std::min(Right,rRect.Right);
    double fBottom = ::std::min(Bottom,rRect.Bottom);
    return fTop<fBottom&&fLeft<fRight;
}

//.............................................................................
} //namespace chart
//.............................................................................
