#ifndef _CHART2_PIECHART_HXX
#define _CHART2_PIECHART_HXX

#include "VSeriesPlotter.hxx"

//.............................................................................
namespace chart
{
//.............................................................................
class PiePositionHelper;

class PieChart : public VSeriesPlotter
{
	//-------------------------------------------------------------------------
	// public methods
	//-------------------------------------------------------------------------
public:
    PieChart( const ::com::sun::star::uno::Reference<
            ::com::sun::star::chart2::XChartType >& xChartTypeModel
            , double fRadiusOffset=0.0, double fRingDistance=0.0 );
	virtual ~PieChart();

	//-------------------------------------------------------------------------
	// chart2::XPlotter
	//-------------------------------------------------------------------------

    virtual void SAL_CALL createShapes();
    /*
	virtual ::rtl::OUString SAL_CALL getCoordinateSystemTypeID(  ) throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setScales( const ::com::sun::star::uno::Sequence< ::com::sun::star::chart2::ExplicitScaleData >& rScales ) throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setTransformation( const ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XTransformation >& xTransformationToLogicTarget, const ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XTransformation >& xTransformationToFinalPage ) throw (::com::sun::star::uno::RuntimeException);
    */

    virtual void addSeries( VDataSeries* pSeries, sal_Int32 xSlot = -1,sal_Int32 ySlot = -1 );

    //MinimumAndMaximumSupplier
    virtual double getMinimumYInRange( double fMinimumX, double fMaximumX );
    virtual double getMaximumYInRange( double fMinimumX, double fMaximumX );

    //-------------------------------------------------------------------------
    //-------------------------------------------------------------------------
    //-------------------------------------------------------------------------
private: //methods
	//no default constructor
	PieChart();

    ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >
        createDataPoint(  const ::com::sun::star::uno::Reference<
                                ::com::sun::star::drawing::XShapes >& xTarget
                        , const ::com::sun::star::uno::Reference<
                                ::com::sun::star::beans::XPropertySet >& xObjectProperties
                        , double fLogicStartAngleValue, double fLogicEndAngleValue
                        , double fLogicInnerRadius, double fLogicOuterRadius
                        , double fLogicZ, double fDepth );
    
    bool                isSingleRingChart() const;

private: //member
    PiePositionHelper*                m_pPosHelper;
};
//.............................................................................
} //namespace chart
//.............................................................................
#endif
