/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: c_stgifc.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:03:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_STORE_C_STGIFC_HXX
#define ARY_STORE_C_STGIFC_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS


namespace ary
{
namespace store
{
    namespace cpp
    {
        class CodeEntity_Ifc;
        class Type_Ifc;
        class Defs_Ifc;
    }

    class Storage;
    class Groups_Ifc;

class Interface_Cpp
{
  public:
	// LIFECYCLE
						Interface_Cpp(
                            Storage &           io_rStorage );
						~Interface_Cpp();

	// ACCESS
    cpp::CodeEntity_Ifc &
                        Ifc_Ces();
    cpp::Type_Ifc &     Ifc_Types();
    cpp::Defs_Ifc &     Ifc_Defs();
    Groups_Ifc &        Ifc_Groups();


  private:
	// DATA
    Dyn<cpp::CodeEntity_Ifc>
                        pIfc_Ces;
	Dyn<cpp::Type_Ifc>	pIfc_Types;
	Dyn<cpp::Defs_Ifc>	pIfc_Defs;
    Dyn<Groups_Ifc>     pIfc_Groups;
};



// IMPLEMENTATION

inline cpp::CodeEntity_Ifc &
Interface_Cpp::Ifc_Ces()
    { return *pIfc_Ces; }
inline cpp::Type_Ifc &
Interface_Cpp::Ifc_Types()
    { return *pIfc_Types; }
inline cpp::Defs_Ifc &
Interface_Cpp::Ifc_Defs()
    { return *pIfc_Defs; }
inline Groups_Ifc &
Interface_Cpp::Ifc_Groups()
    { return *pIfc_Groups; }


}   // namespace store
}   // namespace ary



#endif

