/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: FullConceptGraph.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:25:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

import com.sun.xmlsearch.util.IndexAccessor;

class FullConceptGraph extends ConceptGraph {
  protected FullBtreeDict _tmap;
  protected FullVectorBtree _edges;
  private int _freeID = 0;
  
  public FullConceptGraph(String dbName, boolean update) throws Exception {
    Schema schema = new Schema(new IndexAccessor(dbName), update);
    _edges = new FullVectorBtree(new VectorBtreeParameters(schema, "EDGE"),
				 update);
    _tmap = new FullBtreeDict(new BtreeDictParameters(schema, "DICTIONARY"),
			      update);
  }

  public void addChild(String parent, String child) throws Exception {
    int id1 = intern(parent);
    int id2 = intern(child);
    byte[] link = CompactEdgeFormat.makeVector();
    CompactEdgeFormat.setSrc(link, id1);
    CompactEdgeFormat.setCode(link, CHILD);
    CompactEdgeFormat.setDst(link, id2);
    _edges.insertVector(link);
  }
  
  private int intern(String name) throws Exception {
    int id = _tmap.fetch(name);
    if (id == 0)
      _tmap.store(name, id = _freeID++);
    return id;
  }
  
  public static void main(String[] args) {
    try {
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
