/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartFrame;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.VerticalCategoryPlot;
import com.jrefinery.chart.VerticalIntervalBarRenderer;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.tooltips.IntervalCategoryToolTipGenerator;
import com.jrefinery.data.DefaultIntervalCategoryDataset;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.Locale;

public class IntervalBarChartDemo {
    private static final String[] CATEGORIES = new String[]{"1", "3", "5", "10", "20"};
    private static Color[] dataColors = null;
    private static Font labelFont = null;
    private static Font titleFont = null;
    private JFreeChart chart = null;

    public IntervalBarChartDemo() {
        DefaultIntervalCategoryDataset defaultIntervalCategoryDataset = null;
        double[][] dArrayArray = new double[][]{{-0.0315, 0.0159, 0.0306, 0.0453, 0.0557}};
        double[][] dArrayArray2 = new double[][]{{0.1931, 0.1457, 0.131, 0.1163, 0.1059}};
        defaultIntervalCategoryDataset = new DefaultIntervalCategoryDataset(dArrayArray, dArrayArray2);
        defaultIntervalCategoryDataset.setCategories(CATEGORIES);
        String string = "Strategie Sicherheit";
        String string2 = "Zeitraum (in Jahren)";
        String string3 = "Performance";
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        horizontalCategoryAxis.setLabelFont(titleFont);
        horizontalCategoryAxis.setTickLabelFont(labelFont);
        horizontalCategoryAxis.setTickMarksVisible(false);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        verticalNumberAxis.setLabelFont(titleFont);
        verticalNumberAxis.setTickLabelFont(labelFont);
        verticalNumberAxis.setMinimumAxisValue(-0.2);
        verticalNumberAxis.setMaximumAxisValue(0.4);
        DecimalFormat decimalFormat = new DecimalFormat("0.##%");
        verticalNumberAxis.setTickUnit(new NumberTickUnit(0.05, decimalFormat));
        VerticalIntervalBarRenderer verticalIntervalBarRenderer = null;
        verticalIntervalBarRenderer = new VerticalIntervalBarRenderer(new IntervalCategoryToolTipGenerator(), null);
        VerticalCategoryPlot verticalCategoryPlot = null;
        verticalCategoryPlot = new VerticalCategoryPlot(defaultIntervalCategoryDataset, horizontalCategoryAxis, verticalNumberAxis, verticalIntervalBarRenderer);
        verticalCategoryPlot.setLabelFont(labelFont);
        verticalCategoryPlot.setLabelFormatString("0.##%");
        verticalCategoryPlot.setBackgroundPaint(Color.lightGray);
        verticalCategoryPlot.setOutlinePaint(Color.white);
        verticalCategoryPlot.setSeriesPaint(dataColors);
        this.chart = new JFreeChart(string, titleFont, verticalCategoryPlot, false);
        this.chart.setBackgroundPaint(Color.white);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public static void main(String[] stringArray) {
        Locale.setDefault(Locale.GERMANY);
        IntervalBarChartDemo intervalBarChartDemo = new IntervalBarChartDemo();
        JFreeChart jFreeChart = intervalBarChartDemo.getChart();
        ChartFrame chartFrame = new ChartFrame("Interval Bar Chart Demo", jFreeChart);
        chartFrame.pack();
        chartFrame.setVisible(true);
    }

    static {
        dataColors = new Color[1];
        IntervalBarChartDemo.dataColors[0] = new Color(51, 102, 153);
        labelFont = new Font("Helvetica", 0, 10);
        titleFont = new Font("Helvetica", 1, 14);
    }
}

