/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITAHTMLVIEW_H
#define KITAHTMLVIEW_H

#include <khtmlview.h>

/**
@author Hideki Ikemoto
*/
class KitaHTMLView : public KHTMLView
{
    Q_OBJECT
public:
    KitaHTMLView( KHTMLPart* part, QWidget *parent, const char *name = 0 );
    ~KitaHTMLView();
protected:
    void leaveEvent( QEvent* );
    void keyPressEvent( QKeyEvent* e );
    void viewportWheelEvent( QWheelEvent * e );

private:
    bool emitPushDown();

signals:
    void leave();
    void pushDown();
};

#endif
