/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __panelbutton_h__
#define __panelbutton_h__

#include <algorithm>

#include <qbutton.h>

#include <kpanelapplet.h>
#include <kpanelextension.h>
#include <kurldrag.h>

class QPopupMenu;
class KConfigGroup;

class KDE_EXPORT PanelButton: public QButton
{
    Q_OBJECT

public:
    PanelButton( QWidget* parent, const char* name );

    virtual void configure();
    virtual void saveConfig(KConfigGroup&) const {}
    virtual void properties() {}
    virtual int preferredDimension(int panelDim) const;
    virtual const QPixmap& labelIcon() const;
    virtual const QPixmap& zoomIcon() const { return m_iconz; }

    bool isValid() const { return m_valid; };

    void setTitle(const QString& t) { m_title = t; }
    const QString& title() const { return m_title; }

    void setTip(const QString& tip);
    const QString& tip() const { return m_tip; }

    void setTile(const QString&, const QColor& color = QColor());
    void setDrawArrow(bool drawArrow);

    void setIcon(const QString&);
    const QString& icon() const { return m_iconName; }

    Orientation orientation() const { return m_orientation; }
    KPanelApplet::Direction popupDirection() const { return m_popupDirection; }
    QPoint center() const { return mapToGlobal(rect().center()); }

    static QImage loadTile(const QString& name, const QSize&,
                           const QString& state = QString::null);

signals:
    void iconChanged();
    void requestSave();
    void removeme();
    void dragme(const KURL::List, const QPixmap);
    void dragme(const QPixmap);

public slots:
    void setOrientation(Orientation o) { m_orientation = o; }
    void setPopupDirection(KPanelApplet::Direction d);
    void movieUpdate(const QRect&);
    void movieStatus(int);

protected:
    virtual QString tileName() = 0;
    virtual void triggerDrag();
    virtual void startDrag();
    virtual void enterEvent(QEvent *);
    virtual void leaveEvent(QEvent *);
    virtual void dragEnterEvent(QDragEnterEvent *);
    virtual void dragLeaveEvent(QDragLeaveEvent *);
    virtual void dropEvent(QDropEvent *);
    virtual void mouseMoveEvent(QMouseEvent *);
    virtual void mousePressEvent(QMouseEvent *);
    virtual void mouseReleaseEvent(QMouseEvent *);
    virtual void resizeEvent(QResizeEvent*);
    virtual void drawButton(QPainter *);
    virtual void drawButtonLabel(QPainter *);
    virtual int preferredIconSize(int proposed_size = -1) const;
    virtual QString defaultIcon() const { return "unknown"; };

    void setArrowDirection(KPanelExtension::Position dir);
    void loadTiles();
    void loadIcons();
    bool calculateIconSize();

    bool m_valid;
    QPixmap m_icon;

protected slots:
    void updateIcon(int group);
    void updateSettings(int);
    void showMouseOver();
    void hideMouseOver();

private:
    QPoint m_lastLeftMouseButtonPress;
    bool m_isLeftMouseButtonDown;
    bool m_drawArrow;
    bool m_highlight;
    bool m_animated;
    bool m_changeCursorOverItem;
    bool m_hasAcceptedDrag;
    bool m_hasAnimation;
    QColor m_tileColor;
    QString m_tile;
    QString m_title;
    QString m_tip;
    QString m_iconName;
    QPixmap m_up;
    QPixmap m_down;
    QPixmap m_iconh;
    QPixmap m_iconz;
    QMovie *m_movie;
    KPanelExtension::Position m_arrowDirection;
    KPanelApplet::Direction m_popupDirection;
    Orientation m_orientation;
    int m_size;
};

/**
 * Base class for panelbuttons which can popup a menu
 */
class KDE_EXPORT PanelPopupButton : public PanelButton
{
    Q_OBJECT

public:
    PanelPopupButton(QWidget *parent=0, const char *name=0);

    void setPopup(QPopupMenu *);
    QPopupMenu *popup() const;

    bool eventFilter(QObject *, QEvent *);

protected:
    virtual void initPopup() {};
    virtual void triggerDrag();

protected slots:
    virtual void slotExecMenu();

private:
    QPopupMenu *m_popup;
    bool m_pressedDuringPopup;
};

#endif // __panelbutton_h__
