/***************************************************************************
 *   Copyright (C) 2003 by Martin Koller                                   *
 *   m.koller@surfeu.at                                                    *
 *   This file is part of the KDE Control Center Module for Joysticks      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _CALDIALOG_H_
#define _CALDIALOG_H_

#include <kdialogbase.h>

class QLabel;

class JoyDevice;

// the dialog which tells the user all steps to calibrate the device

class CalDialog : public KDialogBase
{
  Q_OBJECT
  
  public:
    CalDialog(QWidget *parent, JoyDevice *joy);

    void calibrate();

  private:
    void waitButton(int axis, bool press, int &lastVal);

  private:
    JoyDevice *joydev;

    QLabel *text;
    QLabel *valueLbl;
};

#endif
