/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxcolor.cpp,v 1.3.16.1 2004/07/09 01:54:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxcom.h"
#include "hxresult.h"
#include "ihxpckts.h"

// hxcont
#include "hxbuffer.h"
#include "hxstring.h"

// hxmisc
#include "unkimp.h"
#include "baseobj.h"

// pxcomlib
#include "gstring.h"
#include "pxutil.h"
#include "pxcolor.h"

// hxdebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

BEGIN_INTERFACE_LIST(PXColor)
END_INTERFACE_LIST

const UINT32 PXColor::m_pulPredefinedColor[kNumPredefinedColors] =
{
    0x000000,  0x008000, 0xC0C0C0, 0x00FF00, 0x808080, 0x808000, 0xFFFFFF, 0xFFFF00,
    0x800000,  0x000080, 0xFF0000, 0x0000FF, 0x800080, 0x008080, 0xFF00FF, 0x00FFFF
};

const char* const PXColor::m_ppPredefinedColorName[kNumPredefinedColors] =
{
    "black",  "green", "silver", "lime", "gray",   "olive", "white",   "yellow",
    "maroon", "navy",  "red",    "blue", "purple", "teal",  "fuchsia", "aqua"
};

void PXColor::Pack(BYTE * &pBuffer, UINT32 ulMajVer, UINT32 ulMinVer)
{
    pBuffer[0] = m_ucRed;
    pBuffer[1] = m_ucGreen;
    pBuffer[2] = m_ucBlue;
    pBuffer[3] = m_ucAlpha;
    pBuffer   += 4;
}

void PXColor::UnPack(BYTE * &pBuffer, UINT32 ulMajVer, UINT32 ulMinVer)
{
    m_ucRed   = pBuffer[0];
    m_ucGreen = pBuffer[1];
    m_ucBlue  = pBuffer[2];
    m_ucAlpha = pBuffer[3];
    pBuffer  += 4;
}

HX_RESULT PXColor::InitFromString(const char *pszStr)
{
    // Try the "#rrggbb" format first
    UINT32 ulRed, ulGreen, ulBlue;
    INT32  lNumRet = sscanf(pszStr, "#%02X%02X%02X", &ulRed, &ulGreen, &ulBlue);
    if (lNumRet != 3)
    {
        // Try the "#rrggbb" format without the "#"
        lNumRet = sscanf(pszStr, "%02X%02X%02X", &ulRed, &ulGreen, &ulBlue);
    }
    if (lNumRet == 3)
    {
        // Check to make sure the values are in range
        if (ulRed > 255 || ulGreen > 255 || ulBlue > 255)
        {
            return HXR_FAIL;
        }

        // Assign the values
        m_ucRed   = (BYTE) ulRed;
        m_ucGreen = (BYTE) ulGreen;
        m_ucBlue  = (BYTE) ulBlue;
    }
    else
    {
        // String is not in the "#rrggbb" or "rrggbb" format, so try one of the predefined colors
        UINT32 i;
        for (i = 0; i < kNumPredefinedColors; i++)
        {
            if (!strcmp(pszStr, m_ppPredefinedColorName[i]))
            {
                // We found a match
                break;
            }
        }

        if (i >= kNumPredefinedColors)
        {
            // We didn't find a match
            return HXR_FAIL;
        }

        UINT32 ulColor = m_pulPredefinedColor[i];
        m_ucRed        = (unsigned char) ((ulColor >> 16) & 0x000000FF);
        m_ucGreen      = (unsigned char) ((ulColor >>  8) & 0x000000FF);
        m_ucBlue       = (unsigned char) ( ulColor        & 0x000000FF);
    }

    return HXR_OK;
}

