/* GLIB - Library of useful routines for C programming
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GLib Team and others 1997-1999.  See the AUTHORS
 * file for a list of people on the GLib Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GLib at ftp://ftp.gtk.org/pub/gtk/. 
 */

/*
 * Modified by INOUE Seiichiro <inoue@ainet.or.jp>
 * for xyaku <http://www.ainet.or.jp/~inoue/software/xyaku/>.
 * I picked up only hash table routines.
 * Read ghash.c and gprimes.c about changes.
 */

#ifndef __G_LIB_H__
#define __G_LIB_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#undef	CLAMP
#define CLAMP(x, low, high)  (((x) > (high)) ? (high) : (((x) < (low)) ? (low) : (x)))

/* Forward declarations of glib types.
 */
typedef struct _GHashTable	GHashTable;

typedef int		(*GCompareFunc)		(const char *a,
									 const char *b);
typedef unsigned int (*GHashFunc)		(const char *key);
typedef void		(*GHFunc)		(char *key,
									 char *value,
									 void *user_data);

/* Hash tables
 */
GHashTable* g_hash_table_new		(GHashFunc	 hash_func,
									 GCompareFunc	 key_compare_func);
void	    g_hash_table_destroy	(GHashTable	*hash_table);
void	    g_hash_table_insert		(GHashTable	*hash_table,
									 char *key,
									 char *value);
void	    g_hash_table_remove		(GHashTable	*hash_table,
									 const char *key);
const char* g_hash_table_lookup		(GHashTable	*hash_table,
									 const char *key);
int    g_hash_table_lookup_extended(GHashTable	*hash_table,
									const char *lookup_key,
									const char **orig_key,
									const char **value);
void	    g_hash_table_freeze		(GHashTable	*hash_table);
void	    g_hash_table_thaw		(GHashTable	*hash_table);
void	    g_hash_table_foreach	(GHashTable	*hash_table,
									 GHFunc		 func,
									 void *user_data);
unsigned int   g_hash_table_size		(GHashTable	*hash_table);


/* Prime numbers.
 */

/* This function returns prime numbers spaced by approximately 1.5-2.0
 * and is for use in resizing data structures which prefer
 * prime-valued sizes.	The closest spaced prime function returns the
 * next largest prime, or the highest it knows about which is about
 * MAXINT/4.
 */
unsigned int	   g_spaced_primes_closest (unsigned int num);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __G_LIB_H__ */
