/*
 * X Window System event handling module
 * In fact, this module is the main loop.
 *
 * 1998/04/25
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>

#include "xyaku.h"
#include "xpopup.h"
#include "addin.h"


/* Private function prototype */
static void rootwin_proc(const XEvent *pxev, XPopup *xpop);


/*
 *  Event loop
 *  Called by main(), and never return.
 */
void
mainloop(XPopup *xpop)
{
	Window	rootwin = DefaultRootWindow(dpy);
	XEvent	xev;

	while (1) {
		XtAppNextEvent(app, &xev);
		XtDispatchEvent(&xev);
		if (xev.xany.window == rootwin) {
			rootwin_proc(&xev, xpop);
		}
#ifdef DEBUG
		if (xev.xany.window == xpopup_get_xwin(xpop)) {
			printf("type=%d\n", xev.type);
		}
#endif			
	}
}


/*
 * Root window's events handler
 * This is indeed a main entry point of xyaku, although function name doesn't look so...
 * The handler of the grabbed key-press event.
 */
static void
rootwin_proc(const XEvent *pxev, XPopup *xpop)
{
	KeySym ksym;
	XWindowAttributes	attr;
	int ret;
	
	switch (pxev->type) {
	case KeyPress:
		XGetWindowAttributes(dpy, xpopup_get_xwin(xpop), &attr);
		if (attr.map_state == IsUnmapped) {
			CmdInfo cmd;
			EtcInfo etc;
			
			ksym = XKeycodeToKeysym(dpy, pxev->xkey.keycode, 0);
			if (ksym == NoSymbol)
				return;
			ret = find_addin_cmd(&cmd, ksym, pxev->xkey.state, &etc);
			if (ret) {
				xpopup_set_addin_cmd(xpop, cmd.cmd_path, cmd.argv,
									 etc.max_nlines, etc.max_bufsiz, etc.max_width);
				xpopup_set_use_cache(xpop, etc.f_use_cache);
				xpopup_set_automode(xpop, etc.f_automode, etc.interval);
				
				XMoveWindow(dpy, xpopup_get_xwin(xpop), pxev->xkey.x, pxev->xkey.y);
				/* Request for available list of selection data type.
				 * This implicitly calls SelectionNotify event handler of popup window. */
				req_selection(XA_PRIMARY, XA_TARGETS, XA_TARGETS,
							  xpopup_get_xwin(xpop), pxev->xkey.time);
			}
		} else {
			xpopup_set_automode(xpop, 0, 0);
			XtUnmapWidget(xpopup_get_widget(xpop));
		}
		break;
		
	default:
		/* Nothing to do */
		break;
	}
}
