/*
 *  libghal
 *
 *  Copyright (c) 2007 Brian Tarricone <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GHAL_VOLUME_DISC_H__
#define __GHAL_VOLUME_DISC_H__

#if !defined(GHAL_IN_GHAL_H) && !defined(GHAL_COMPILATION)
#error "Do not include ghal-volume-disc.h directly.  Instead use <ghal/ghal.h>"
#endif

#include <libhal-storage.h>

#include <ghal/ghal-volume.h>

#define GHAL_TYPE_VOLUME_DISC     (ghal_volume_get_type())
#define GHAL_VOLUME_DISC(obj)     (G_TYPE_CHECK_INSTANCE_CAST((obj), GHAL_TYPE_VOLUME, GHalVolume))
#define GHAL_IS_VOLUME_DISC(obj)  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GHAL_TYPE_VOLUME))

G_BEGIN_DECLS

typedef struct _GHalVolumeDisc         GHalVolumeDisc;
typedef struct _GHalVolumeDiscClass    GHalVolumeDiscClass;
typedef struct _GHalVolumeDiscPrivate  GHalVolumeDiscPrivate;

struct _GHalVolumeDisc
{
    GHalVolume parent;
    
    /*< private >*/
    GHalVolumeDiscPrivate *priv;
};

struct _GHalVolumeDiscClass
{
    GHalVolumeClass parent;
};

GType ghal_volume_disc_get_type() G_GNUC_CONST;

guint64 ghal_volume_disc_get_capacity(GHalVolumeDisc *disc);

gboolean ghal_volume_disc_has_audio(GHalVolumeDisc *disc);
gboolean ghal_volume_disc_has_data(GHalVolumeDisc *disc);
gboolean ghal_volume_disc_is_blank(GHalVolumeDisc *disc);
gboolean ghal_volume_disc_is_rewritable(GHalVolumeDisc *disc);
gboolean ghal_volume_disc_is_appendable(GHalVolumeDisc *disc);

LibHalVolumeDiscType ghal_volume_disc_get_disc_type(GHalVolumeDisc *disc);

G_END_DECLS

#endif  /* __GHAL_VOLUME_DISC_H__ */
