/*
 *  libghal
 *
 *  Copyright (c) 2007 Brian Tarricone <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GHAL_TYPES_H__
#define __GHAL_TYPES_H__

#if !defined(GHAL_IN_GHAL_H) && !defined(GHAL_COMPILATION)
#error "Do not include ghal-types.h directly.  Instead use <ghal/ghal.h>"
#endif

#include <glib-object.h>

G_BEGIN_DECLS

typedef enum
{
    GHAL_PROPERTY_CHANGED = 0,
    GHAL_PROPERTY_ADDED,
    GHAL_PROPERTY_REMOVED,
} GhalPropertyChangeType;

G_END_DECLS

#endif  /* __GHAL_TYPES_H__ */
