/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "statusbar.h"
#include "debug.h"

GtkWidget *create_statusbar()
{
	_DEBUG(("create_statusbar"));
	GtkWidget *statusbar;
	statusbar = gtk_statusbar_new();
	return statusbar;
}

void statusbar_push (GtkStatusbar *statusbar, int id, char *message)
{
	gtk_statusbar_push (statusbar, id, message);
}

void statusbar_pop (GtkStatusbar *statusbar, int id)
{
	gtk_statusbar_pop (statusbar, id);
}
