/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libxfcegui4/libxfcegui4.h>
#include <config.h>
#include <string.h>
#include <stdlib.h>

#include "xfbib.h"
#include "parser_interface.h"
#include "treeview.h"
#include "open.h"
#include "debug.h"
#include "window.h"
#include "statusbar.h"

int open_file (char *filename, struct xfbib *xfbib)
{
	char *opened;
	
	xfbib->filename = filename;
	parse_file(xfbib);
	update_treeview(xfbib);
	_DEBUG(("Opening: %s", xfbib->filename));
	gtk_window_set_title(GTK_WINDOW(xfbib->window.window), create_title(xfbib));
	opened = (char *) malloc(sizeof(char)*(strlen(filename) + strlen(" loaded...") + 1));
	strcpy(opened, filename);
	strcat(opened, _(" loaded..."));
	statusbar_push((GtkStatusbar *) xfbib->window.statusbar, 0, opened);
	return 0;
}
