/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

%{
#define YYSTYPE char*
#include "parser.h"
int lineno = 1;
char *stryychar( char alternative ) ;
%}
%option yylineno nounput
%%
\\[A-Za-z0-9]+				{ yylval = strdup(yytext); return LATEXCOMMAND; }
@[^\\\"	 \n\(\),=\{\}#~]+	{
					yylval = strdup(yytext);
				  if( strcasecmp( yytext, "@string" ) == 0) {
				    return DEFINESTRING ;
				  } else if( strcasecmp( yytext, "@preamble" ) == 0) {
				    return PREAMBLESTRING ;
				  } else if( strcasecmp( yytext, "@comment" ) == 0) {
				    return COMMENTSTRING ;
				  }else {
				    return ATSTRING ;
				  }
				}
[^\\\" 	\n\(\),=\{\}#~]+	{ yylval = strdup(yytext);return STRING ; }
[ \t]*				{ yylval = strdup(yytext);return WHITE; }
\n				{ yylval = strdup(yytext);/*lineno++; */return ENDLINE; }
\"				{ yylval = strdup(yytext);return QUOTE ; }
\(				{ yylval = strdup(yytext);return LBRACKET ; }
\)				{ yylval = strdup(yytext);return RBRACKET ; }
\{				{ yylval = strdup(yytext);return LCBRACKET ; }
\}				{ yylval = strdup(yytext);return RCBRACKET ; }
=				{ yylval = strdup(yytext);return EQUAL ; }
#				{ yylval = strdup(yytext);return HASHSIGN ; }
\,				{ yylval = strdup(yytext);return COMMA ; }
\%[^\n]*			{ yylval = strdup(yytext);return COMMENT ; }
%%
