/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "entry.h"
#include "tag.h"
#include "debug.h"

struct entry *new_entry(char *type, char *key)
{
	_DEBUG(("new_entry"));
	struct entry *new = malloc(sizeof(struct entry));
	if ((new->type = strdup(type)) == NULL)
		fprintf(stderr, "Insufficient amount of memory available\n");
	if ((new->key = strdup(key)) == NULL)
		fprintf(stderr, "Insufficient amount of memory available\n");
	new->tags = NULL;
	return new;
}

void print_entry(struct entry *e)
{
	_DEBUG(("print_entry"));
	write_entry(e, stdout);
}

void write_entry(struct entry *e, FILE *file)
{
	_DEBUG(("write_entry"));
	fprintf(file, "@%s{%s,\n", e->type, e->key);
	write_tags(e->tags, file);
	fprintf(file, "}\n\n");
}

void free_entry(struct entry *e)
{
	_DEBUG(("free_entry"));
	free(e->type);
	free(e->key);
	free_tags(e->tags);
	free(e);
}
