#include <stddef.h>
#include "xen/elfstructs.h"

#include "list.h"

/* ------------------------------------------------------------- */

#include <xen/xen-compat.h>
#if __XEN_LATEST_INTERFACE_VERSION__ < 0x00030208
# define xen_mb()  mb()
# define xen_rmb() rmb()
# define xen_wmb() wmb()
#endif

/* ------------------------------------------------------------- */

#define container_of(ptr, type, member) ({                      \
        const typeof( ((type *)0)->member ) *__mptr = (ptr);    \
        (type *)( (char *)__mptr - offsetof(type,member) );})

/* ------------------------------------------------------------- */

#define BUFSIZE 256

enum xendev_state {
    XENDEV_UNKNOWN = 0,
    XENDEV_PROBED,
    XENDEV_INITIALISED,
    XENDEV_CONNECTED,
    XENDEV_DISCONNECTED,
};

struct xendev;

struct devops {
    size_t size;
    int    (*alloc)(struct xendev *xendev);
    int    (*setup)(struct xendev *xendev);
    int    (*xs_be)(struct xendev *xendev, char *node, char *val);
    int    (*xs_fe)(struct xendev *xendev, char *node, char *val);
    void   (*stats)(struct xendev *xendev, FILE *fp);
    int    (*free)(struct xendev *xendev);
};

struct xendev {
    char               *be_root;
    int                dom;
    int                dev;
    enum xendev_state  state;
    enum xenbus_state  be_state;
    enum xenbus_state  fe_state;
    int                online;
    char               *fe;
    char               *protocol;
    int                remote_port;
    int                local_port;

    int                evtchnd;
    int                gnttabdev;
    struct xs_handle   *xs;

    struct devops      *ops;
    struct list_head   next;
};

/* ------------------------------------------------------------- */

int write_be_str(struct xendev *xendev, char *node, char *val);
int write_be_int(struct xendev *xendev, char *node, int ival);
char *read_be_str(struct xendev *xendev, char *node);
int read_be_int(struct xendev *xendev, char *node);
char *read_fe_str(struct xendev *xendev, char *node);
int read_fe_int(struct xendev *xendev, char *node);

int wait_for_data(int fd, int timeout);
int wait_for_event(struct xendev *xendev);

int change_state_xendev(struct xendev *xendev, enum xenbus_state state);
int mainloop(struct devops *ops, char *be_name, int stat_secs);

/* small helpers */
uint32_t timediff_msecs(struct timeval *n, struct timeval *o);
