#include "processor.h"

typedef unsigned long pfn_t;

/* ------------------------------------------------------------------ */

uint32_t *find_pgd_32(struct xenvcpu *vcpu, uint32_t va);
uint32_t *find_pte_32(struct xenvcpu *vcpu, uint32_t va);
void *find_pa_32(struct xenvcpu *vcpu, uint32_t va);
int map_region_pse_32(struct xenvcpu *vcpu, uint32_t va, uint32_t flags,
		      pfn_t start, pfn_t count);
int map_linear_pgt_32(struct xenvcpu *vcpu, uint32_t va, uint32_t flags);
int map_normal_pgt_32(struct xenvcpu *vcpu, uint32_t va, uint32_t flags,
		      pfn_t table);

uint64_t *find_pgd_pae(struct xenvcpu *vcpu, uint32_t va);
uint64_t *find_pmd_pae(struct xenvcpu *vcpu, uint32_t va);
uint64_t *find_pte_pae(struct xenvcpu *vcpu, uint32_t va);
void *find_pa_pae(struct xenvcpu *vcpu, uint32_t va);
int map_region_pse_pae(struct xenvcpu *vcpu, uint32_t va, uint32_t flags,
		       pfn_t start, pfn_t count);
int map_linear_pgt_pae(struct xenvcpu *vcpu, uint32_t va, uint32_t flags);
int map_normal_pgt_pae(struct xenvcpu *vcpu, uint32_t va, uint32_t flags,
		       pfn_t table);
void dump_pgtables_pae(struct xenvcpu *vcpu, uint32_t vaddr);

uint64_t *find_pgd_64(struct xenvcpu *vcpu, uint64_t va);
uint64_t *find_pud_64(struct xenvcpu *vcpu, uint64_t va);
uint64_t *find_pmd_64(struct xenvcpu *vcpu, uint64_t va);
uint64_t *find_pte_64(struct xenvcpu *vcpu, uint64_t va);
void *find_pa_64(struct xenvcpu *vcpu, uint64_t va);
int map_region_pse_64(struct xenvcpu *vcpu, uint64_t va, uint32_t flags,
		      pfn_t start, pfn_t count);
int map_linear_pgt_64(struct xenvcpu *vcpu, uint64_t va, uint32_t flags);

/* ------------------------------------------------------------------ */

void *mfn_to_ptr(struct xenvm *xen, uint64_t mfn);

void *emu_paddr_to_ptr(struct xenvm *xen, uint64_t addr);
void *emu_vaddr_to_ptr(struct xenvm *xen, uint64_t addr);

void *guest_paddr_to_ptr(struct xenvm *xen, uint64_t addr);
void *guest_vaddr_to_ptr(struct xenvcpu *vcpu, uint64_t addr);
int copy_from_guest(struct xenvcpu *vcpu, void *dest, uint64_t vaddr, size_t size);
int copy_to_guest(struct xenvcpu *vcpu, uint64_t vaddr, void *src, size_t size);

/* ------------------------------------------------------------------ */
