
void *get_pages(int pages, char *purpose)
{
    static void *heap_top;
    void *ptr;

    if (!heap_top)
	heap_top = _vstop;
    ptr = heap_top;
    heap_top += pages * PAGE_SIZE;
    printk(2, "%s: %d page(s) at %p (for %s)\n",
	   __FUNCTION__, pages, ptr, purpose);
    memset(ptr, 0, pages * PAGE_SIZE);
    return ptr;
}

void *get_memory(int bytes, char *purpose)
{
    int pages = (bytes + PAGE_SIZE -1) / PAGE_SIZE;
    return get_pages(pages, purpose);
}

void paging_start(struct xen_cpu *cpu)
{
    ureg_t cr3_mfn;

    cr3_mfn = cpu->init_ctxt->ctrlreg[3] >> PAGE_SHIFT;
    update_emu_mappings(cr3_mfn);
    pv_write_cr3(cpu, cr3_mfn);
}
