#include "emu.h"

#if longmode

struct idt_64 page_aligned xen_idt[256];
uint64_t *m2p;

#else

struct descriptor_32 page_aligned xen_idt[256];
uint32_t *m2p;

page_aligned uint32_t maps_32[PTE_COUNT_32];
page_aligned uint64_t maps_pae[PTE_COUNT_PAE];
uint32_t maps_refcnt[MAPS_MAX];

#endif

page_aligned struct vcpu_guest_context boot_ctxt;
LIST_HEAD(cpus);

int grant_frames;
struct grant_entry page_aligned grant_table[GRANT_ENTRIES];
struct shared_info page_aligned shared_info;
struct xenner_info page_aligned vminfo = {
    .abi_version          = XENNER_ABI_VERSION,
};

struct vmconfig  vmconf;
xen_callback_t   xencb[8];
struct trap_info xentr[256];
int wrpt;

/* trap/fault info */
const struct trapinfo trapinfo[32] = {
    [  0 ] = { .name = "division by zero",              .ec = 0, .lvl = 1 },
    [  1 ] = { .name = "debug interrupt",               .ec = 0, .lvl = 3 },
    [  2 ] = { .name = "NMI",                           .ec = 0, .lvl = 1 },
    [  3 ] = { .name = "breakpoint",                    .ec = 0, .lvl = 3 },
    [  4 ] = { .name = "overflow",                      .ec = 0, .lvl = 1 },
    [  5 ] = { .name = "bound check",                   .ec = 0, .lvl = 1 },
    [  6 ] = { .name = "illegal instruction",           .ec = 0, .lvl = 1 },
    [  7 ] = { .name = "device not present",            .ec = 0, .lvl = 1 },
    [  8 ] = { .name = "double fault",                  .ec = 1, .lvl = 0 },
    [  9 ] = { .name = "coprocessor",                   .ec = 0, .lvl = 1 },
    [ 10 ] = { .name = "invalid TSS",                   .ec = 1, .lvl = 0 },
    [ 11 ] = { .name = "segment not pesent",            .ec = 1, .lvl = 1 },
    [ 12 ] = { .name = "stack fault",                   .ec = 1, .lvl = 1 },
    [ 13 ] = { .name = "general protection fault",      .ec = 1, .lvl = 1 },
    [ 14 ] = { .name = "page fault",                    .ec = 1, .lvl = 1 },
    [ 16 ] = { .name = "floating point exception",      .ec = 0, .lvl = 1 },
    [ 17 ] = { .name = "alignment",                     .ec = 1, .lvl = 1 },
    [ 18 ] = { .name = "machine check",                 .ec = 0, .lvl = 1 },
    [ 19 ] = { .name = "SIMD floating point exception", .ec = 0, .lvl = 1 },
};

const char *cr0_bits[32] = {
    [  0 ] = "PE",
    [  1 ] = "MP",
    [  2 ] = "EM",
    [  3 ] = "TS",
    [  4 ] = "ET",
    [  5 ] = "NE",
    [ 16 ] = "WP",
    [ 18 ] = "AM",
    [ 29 ] = "NW",
    [ 30 ] = "CD",
    [ 31 ] = "PG",
};

const char *cr4_bits[32] = {
    [  0 ] = "VME",
    [  1 ] = "PVI",
    [  2 ] = "TSD",
    [  3 ] = "DE",
    [  4 ] = "PSE",
    [  5 ] = "PAE",
    [  6 ] = "MCE",
    [  7 ] = "PGE",
    [  8 ] = "PCE",
    [  9 ] = "OSFXSR",
    [ 10 ] = "OSXMMEXCPT",
};

const char *pg_bits[32] = {
    [ 0 ] = "present",
    [ 1 ] = "write",
    [ 2 ] = "user",
    [ 3 ] = "pwt",
    [ 4 ] = "pcd",
    [ 5 ] = "access",
    [ 6 ] = "dirty",
    [ 7 ] = "pse",
    [ 8 ] = "global",
};

const char *rflags_bits[32] = {
    [  0 ] = "CF",
    [  2 ] = "PF",

    [  4 ] = "AF",
    [  6 ] = "ZF",

    [  8 ] = "TF",
    [  9 ] = "IF",
    [ 10 ] = "DF",
    [ 11 ] = "OF",

    [ 12 ] = "IOPL-1",
    [ 13 ] = "IOPL-2",
    [ 14 ] = "NT",

    [ 16 ] = "RF",
    [ 17 ] = "VM",
    [ 18 ] = "AC",
    [ 19 ] = "VIF",

    [ 20 ] = "VIP",
    [ 21 ] = "ID",
};
