/* from linux/asm-x86/bitops.h */

#if __GNUC__ < 4 || (__GNUC__ == 4 && __GNUC_MINOR__ < 1)
/* Technically wrong, but this avoids compilation errors on some gcc
   versions. */
#define ADDR "=m" (*(volatile long *) addr)
#else
#define ADDR "+m" (*(volatile long *) addr)
#endif

static inline void set_bit(int nr, volatile void *addr)
{
	asm volatile("lock bts %1,%0"
		     : ADDR
		     : "Ir" (nr) : "memory");
}

static inline void clear_bit(int nr, volatile void *addr)
{
	asm volatile("lock btr %1,%0"
		     : ADDR
		     : "Ir" (nr));
}

static inline int test_and_set_bit(int nr, volatile void *addr)
{
	int oldbit;

	asm volatile("lock bts %2,%1\n\t"
		     "sbb %0,%0"
		     : "=r" (oldbit), ADDR
		     : "Ir" (nr) : "memory");

	return oldbit;
}

static inline int test_and_clear_bit(int nr, volatile void *addr)
{
	int oldbit;

	asm volatile("lock btr %2,%1\n\t"
		     "sbb %0,%0"
		     : "=r" (oldbit), ADDR
		     : "Ir" (nr) : "memory");

	return oldbit;
}

static inline int test_bit(int nr, volatile const void *addr)
{
	int oldbit;

	asm volatile("bt %2,%1\n\t"
		     "sbb %0,%0"
		     : "=r" (oldbit)
		     : "m" (*(unsigned long *)addr), "Ir" (nr));

	return oldbit;
}

