class PhotoPage < ControlPage

  def initialize(parent = nil)
    super(parent)

    @name = Qt::LineEdit.new

    info = "By default current time and date<br>are used as file name."
    @name_info = Qt::Label.new {set_word_wrap true}
    @name_info.text = center(small_font(info))

    name_layout = Qt::HBoxLayout.new do |l|
      l.no_margins
      l.no_spaces
      l.add_stretch 
      l.add_widget labeled_widget('Photo Name:', @name)
      l.add_stretch 
    end

    @format = Qt::ComboBox.new do
      add_item("PNG")
      add_item("JPEG")
    end
    @format.connect(SIGNAL('currentIndexChanged(QString)')) do |text|
      enable = (text == 'JPEG')
      @quality.set_enabled enable
      @quality_label.set_enabled enable
    end

    format_label = Qt::Label.new('Image Format:') { |l| l.set_buddy  @format}
   
    @quality = Qt::Slider.new(Qt::Horizontal) do
      set_minimum 0
      set_maximum 10
      set_tick_position Qt::Slider::TicksBelow
      set_value 10
    end
    @quality.set_disabled true


    @quality_label = Qt::Label.new('Image Quality:')
    @quality_label.set_buddy  @quality
    @quality_label.set_disabled true

    format_layout = Qt::GridLayout.new do |l|
      l.no_spaces
      l.no_margins
      l.set_column_stretch(0, 1)
      l.add_widget(format_label, 0, 1, Qt::AlignRight)
      l.add_widget(@format, 0, 2)
      l.add_widget(@quality_label, 1, 1, Qt::AlignRight)
      l.add_widget(@quality, 1, 2)
      l.set_column_stretch(3, 1)
    end

    take_photo = Qt::PushButton.new
    take_photo.text = 'Take a photo'
    take_photo.icon = $webkam_app.icon(:photo)
    take_photo.icon_size = Qt::Size.new(22, 22)
    font = take_photo.font
    font.point_size += 1
    take_photo.font = font
    take_photo.connect(SIGNAL :clicked) {save_photo}

    add_spacing 5

    add_widget(take_photo, 0, Qt::AlignCenter)
    
    add_spacing 5

    add_widget Qt::Frame.new{set_frame_shape Qt::Frame::HLine}

    add_group('Photo Options', :photo_small, false) do |g|
      g.add_layout name_layout
      g.add_widget @name_info
      g.add_spacing 15
      g.add_layout format_layout
    end

    add_stretch

    take_photo.resize(take_photo.width, take_photo.height * 2)

  end

  def save_photo
    $webkam_app.make_path($settings.photo_path) unless File.exist?($settings.photo_path)

    if @name.text == ''
      name = Qt::DateTime.current_date_time.to_string
    else
      name = @name.text
    end

    index = 0

    loop do
      full_name = $settings.photo_path + '/' + name
      full_name += '(' + index.to_s + ')' unless index == 0
      full_name += (@format.current_text == "PNG") ? '.png' : '.jpg'

      unless Qt::File.new(full_name).exists
        WebcamVideoStream.instance.save_frame(full_name, @format.current_text, @quality.value * 10)
        break
      end

      index += 1
    end

    Flash.new.show if $settings.flash

    $webkam_app.play_sound(:shutter)
  end

end

class Flash < Qt::Widget
  def initialize(parent = nil)
    super(parent)

    set_parent($webkam_app.desktop, Qt::FramelessWindowHint | Qt::Popup)
    move(0, 0)
    resize($webkam_app.desktop.size)

    set_attribute Qt::WA_NoSystemBackground

    @color = Qt::Color.new('white')    
    @color.alpha = 0

    @timer = Qt::Timer.new(self)
    @timer.connect(SIGNAL :timeout) { change_alpha }
    @timer.start(25)
  end

  def change_alpha
      if @color.alpha == 160
      @timer.stop
      close
    else
      @color.alpha = @color.alpha + 20
      repaint
    end
  end


  def paintEvent(event)
    painter = Qt::Painter.new(self)
    painter.fill_rect(event.rect, Qt::Brush.new(@color))
    painter.dispose
  end

end



