#ifndef __vumeter_h
#define __vumeter_h

#define window_topic    "Analog VU meter 0.9"

#define SKINDIR		"/usr/share/xmms/VU_meter_skins"
#define global_skin_dir SKINDIR
#define max_avarage_samples 20


struct vumeter_skin_info {
 char   name[200];					// Filename for the skin
 gint   exit_x1,exit_x2,exit_y1,exit_y2,		// Positions for exit button
	config_x1,config_x2,config_y1,config_y2,	// Positions for config button
	titlebar_ymax,					// Max ysize for titlebar
	right_x,right_y,
	left_x,left_y,
	left_mirror,
	right_mirror,
	needle_min_angle,
	needle_max_angle,
	width,height,
	overlay_x,
	overlay_y,
	overlay_enabled,
	analogvu_enabled,
	digitalvu_enabled,
	line_width;
	
 unsigned long line_color;

 float	left_rad,right_rad;
}; 

struct vumeter_cfg_info {
 char   old_skin[200];
 gint	av_samples,
	frame_delay,
	accuracy,
	win_width,
	win_height,
	screen_width,
	screen_height;
};


extern     void scan_skin_dir(char *);				// Scan skin directory (vumeter_skin.c)
extern      int vumeter_test_skin(char *);			// Return 0 if skin not found
extern     void vumeter_about(void);				// About box (vumeter_dialog.c)
extern     void vumeter_config(void);				// Config box (vumeter_dialog.c)
extern      int vumeter_load_skin(char *);			// Skin loader  (arg 1 = name)
extern     void scan_skin_dir(char *);				// Search skins (arg 1 = directory)

extern void *vumeter_worker(void *);				// worker thread

#endif
