#! /usr/bin/env python
# testvid.py

"""
Test-video generator

All tests can be rendered to any of the three major formats (VCD/SVCD/DVD).
Planned rendering capabilities:

Safe-area test:
    Draws expanding box and percentage

Font-test, with user-configurable:
    Font face or faces (to test appearance of multiple fonts)
    Range of pixel-sizes (i.e. 5px to 40px in height)
    Font color

Color-test, with:
    Value gradient from black to white
    Color gradients for primaries/secondaries
    Full spectrum bar
    Natural-light photograph (for hue/sat adjustment)

Display test, with:
    Center of screen indicator
    Safe area indicators
    Horizontal/vertical/diagonal line patterns

Things to keep in mind:
    Cropping
    Scaling
    Compositing (w/ alpha effects, channels, masks)
    Video


Interface I want to have:

    img = Image(720, 480)
    img.background = 'transparent'
    img.draw_text("The quick brown fox\njumped over the lazy dog")
    img.render("test.png")

"""

