/*
 * tmms.h
 * Thomas Nemeth, le 07.01.2002
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef TMMS_H
#define TMMS_H

#include <pthread.h>
#include "terminal.h"

#define CHECK_DISPLAY(auth) \
        if (! auth) \
        { \
                return; \
        }

#define DEFAULT_CFGFILE ".tmmsrc"

typedef enum {NOTHING, PLAYING, PAUSED, STOPPED, FFW, RWD, NEXT, PREV} Status;
typedef enum {REPEAT_NOT, REPEAT_ONE, REPEAT_ALL} Mode;
typedef enum {ELAPSED, REMAINING} TimeData;

/* Elements to be colorized */
typedef enum {
        NormalColor = 0,
        BordersColor,
        WindowTitleColor,
        TimeColor,
        BitrateColor,
        StatusColor,
        PlayedSongColor,
        NumberColor,
        MoveCursorColor,
        SelectedColor,
        ListSongColor,
        NB_COLOR_ELEMENTS
} ColorElement;


/** GLOBAL VARIABLES */
/* Access to current entry */
extern pthread_mutex_t mutex_current;

/* Requests and Status */
extern pthread_mutex_t mutex_request;
extern pthread_mutex_t mutex_status;

/* Display operations */
extern pthread_mutex_t mutex_display;

/* Other global variables */
extern TimeData        timedata;
extern Mode            repeat_mode;
extern char          * output_device;


char *robust_home(const char *user);
int redisp();
int quit();
int reload_list();


#endif

