/*
 * search.c
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "defines.h"
#include <ncurses.h>
#include <readline/readline.h>
#include "terminal.h"
#include "tmms.h"
#include "xmem.h"
#include "input.h"
#include "playlist.h"
#include "playerwin.h"
#include "playlistwin.h"
#include "printlog.h"


static char * search_pattern = NULL;


static char *get_search_pattern(char *title)
{
        char *line, *pattern = NULL;

        player_display = FALSE;
        display_input(title, "Search pattern : ");
        line = readline(NULL);
        if (line && (line[0] != 0))
        {
                pattern = xstrdup(stripwhite(line));
                free(line);
        }
        close_input();

        return pattern;
}


static int search_from(ListID pos, int direction)
{
        int    cont = TRUE;

        while (cont)
        {
                char * title = playlist_get(pos);
                if (! title)
                {
                        pos = -1;
                        break;
                }
                if (strstr(title, search_pattern))
                {
                        break;
                }
                if (direction == 1)
                {
                        pos++;
                }
                else
                {
                        pos--;
                        if (pos == 0)
                        {
                                pos = -1;
                                break;
                        }
                }
        }
        return pos;
}


int search_new()
{
        FREE(search_pattern);
        search_pattern = get_search_pattern("Search title...");

        if (search_pattern)
        {
                int found = search_from(1, 1);
                if (found > -1)
                {
                        set_cursor(found);
                }
        }

        return CONT;
}


int search_next()
{
        if (search_pattern)
        {
                int found = search_from(get_cursor() + 1, 1);
                if (found > -1)
                {
                        set_cursor(found);
                }
        }

        return CONT;
}


int search_prev()
{
        if (search_pattern)
        {
                int found = search_from(get_cursor() + 1, -1);
                if (found > -1)
                {
                        set_cursor(found);
                }
        }

        return CONT;
}

