/*
 * cda_mod.c
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "defines.h"
#include <ncurses.h>
#include "tmms.h"
#include "xmem.h"
#include "playlist.h"
#include "modules.h"


static int parse_cda(const char *datas, int *frame,
                     int *mins, int *secs, int *rms, int *rss, int *br);

static Module CDA = {
        .ext     = ".cda",
        .cmd     = "cda123",
        .pos     = "-k",
        .dev     = "-o",
        .opt     = "-v",
        .postype = SECONDS,
        .parse   = &parse_cda,
        .infos   = NULL
};


void register_cda()
{
        register_module(&CDA);
}


static int parse_cda(const char *datas, int *frame,
                     int *mins, int *secs, int *rms, int *rss, int *br)
{
        int r = 0;
        char *t = strstr(datas, "Time:");

        if (t == datas)
        {
                int cs;
                r = sscanf(datas, "Time: %d:%d.%d [%d:%d]",
                                mins, secs, &cs, rms, rss);
                *br = 0;
                *frame = 0;
        }


        return (r == 8);
}


void load_tracks_list(const char *device)
{
        char *cmd_line;
        FILE *infos;

#define COMMAND "cda123 -l -d "
        cmd_line = xmalloc(strlen(COMMAND) + strlen(device) + 1);
        sprintf(cmd_line, COMMAND"%s", device);
#undef COMMAND
        infos = popen(cmd_line, "r");

        while (! feof(infos))
        {
                char line[MAXSTRLEN];
                memset(line, 0, MAXSTRLEN);
                fgets(line, MAXSTRLEN, infos);
                if (line[0] == '[')
                {
                        char *track = strchr(line, ']') + 2;
                        char *nl = strchr(track, '\n');
                        char  len[10];
                        memset(len, 0, 10);
                        sscanf(line, "[%s] ", len);
                        if (strchr(len, ']') != NULL)
                        {
                                char *c = strchr(len, ']');
                                *c = 0;
                        }
                        *nl = 0;
                        playlist_add_all(track, len);
                }
        }

        free(cmd_line);
        pclose(infos);
}

