-- MySQL dump 10.10
--
-- Host: localhost    Database: tiquit
-- ------------------------------------------------------
-- Server version	5.0.18

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `agent`
--

DROP TABLE IF EXISTS `agent`;
CREATE TABLE `agent` (
  `number` smallint(4) NOT NULL default '0',
  `id` varchar(10) NOT NULL default '',
  `name` varchar(30) NOT NULL default '',
  `password` varchar(30) NOT NULL default '',
  `grp` varchar(20) NOT NULL default '',
  `admin` char(1) NOT NULL default '0',
  `email` varchar(40) NOT NULL default '',
  `title` varchar(40) NOT NULL default '',
  `ll` date NOT NULL default '0000-00-00',
  `enabled` char(1) NOT NULL default '1',
  PRIMARY KEY  (`number`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `agent`
--


/*!40000 ALTER TABLE `agent` DISABLE KEYS */;
LOCK TABLES `agent` WRITE;
INSERT INTO `agent` VALUES (1,'admin','Admin User','adpexzg3FUZAk','My Group','2','you@yourorg.tld','Your Title','0000-00-00','1');
UNLOCK TABLES;
/*!40000 ALTER TABLE `agent` ENABLE KEYS */;

--
-- Table structure for table `audit`
--

DROP TABLE IF EXISTS `audit`;
CREATE TABLE `audit` (
  `number` int(11) NOT NULL default '0',
  `incident` int(8) NOT NULL default '0',
  `action` varchar(20) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `agent` varchar(10) NOT NULL default '',
  `oldval` varchar(20) NOT NULL default '',
  `newval` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`number`),
  KEY `index.aud.inc` (`incident`),
  FULLTEXT KEY `fulltext.aud.act` (`action`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `audit`
--


/*!40000 ALTER TABLE `audit` DISABLE KEYS */;
LOCK TABLES `audit` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `audit` ENABLE KEYS */;

--
-- Table structure for table `diary`
--

DROP TABLE IF EXISTS `diary`;
CREATE TABLE `diary` (
  `number` int(11) NOT NULL default '0',
  `incident` int(11) NOT NULL default '0',
  `agent` int(4) NOT NULL default '0',
  `text` varchar(255) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`number`),
  FULLTEXT KEY `fulltext.dia.tex` (`text`)	
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `diary`
--


/*!40000 ALTER TABLE `diary` DISABLE KEYS */;
LOCK TABLES `diary` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `diary` ENABLE KEYS */;

--
-- Table structure for table `files`
--

DROP TABLE IF EXISTS `files`;
CREATE TABLE `files` (
  `number` int(11) NOT NULL default '0',
  `name` varchar(260) NOT NULL default '',
  `content` longblob NOT NULL,
  `size` mediumint(8) NOT NULL default '0',
  `incident` int(8) NOT NULL default '0',
  `mime` varchar(50) NOT NULL,
  PRIMARY KEY  (`number`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `files`
--


/*!40000 ALTER TABLE `files` DISABLE KEYS */;
LOCK TABLES `files` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `files` ENABLE KEYS */;

--
-- Table structure for table `incident`
--

DROP TABLE IF EXISTS `incident`;
CREATE TABLE `incident` (
  `number` int(11) NOT NULL default '0',
  `type` smallint(4) NOT NULL,
  `usr` smallint(6) NOT NULL default '0',
  `agent` smallint(4) default '0',
  `description` varchar(255) NOT NULL default '',
  `status` varchar(8) NOT NULL default '',
  `resolution` varchar(255) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `closed` datetime default '0000-00-00 00:00:00',
  `severity` varchar(1) NOT NULL default '5',
  `parent` int(8) default '0',
  `logged` smallint(4) default '0',
  `closer` smallint(4) default '0',
  PRIMARY KEY  (`number`),
  KEY `index.inc.usr` (`usr`),
  KEY `index.inc.typ` (`type`),
  KEY `index.inc.age` (`agent`),
  KEY `index.inc.log` (`logged`),
  KEY `index.inc.clo` (`closer`),
  FULLTEXT KEY `fulltext.inc.dec` (`description`),
  FULLTEXT KEY `fulltext.inc.res` (`resolution`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `incident`
--


/*!40000 ALTER TABLE `incident` DISABLE KEYS */;
LOCK TABLES `incident` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `incident` ENABLE KEYS */;

--
-- Table structure for table `knowledgebase`
--

DROP TABLE IF EXISTS `knowledgebase`;
CREATE TABLE `knowledgebase` (
  `number` int(11) NOT NULL default '0',
  `topic` varchar(50) NOT NULL default '',
  `text` text NOT NULL,
  `lastagent` varchar(10) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`number`),
  FULLTEXT KEY `fulltext.kno.tex` (`text`)	
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `knowledgebase`
--


/*!40000 ALTER TABLE `knowledgebase` DISABLE KEYS */;
LOCK TABLES `knowledgebase` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `knowledgebase` ENABLE KEYS */;

--
-- Table structure for table `location`
--

DROP TABLE IF EXISTS `location`;
CREATE TABLE `location` (
  `number` smallint(3) NOT NULL default '0',
  `name` varchar(20) NOT NULL default '',
  `street` varchar(40) NOT NULL default '',
  `city` varchar(20) NOT NULL default '',
  `state` char(3) NOT NULL default '',
  `zip` varchar(9) NOT NULL default '',
  `country` varchar(10) NOT NULL default '',
  `phone` varchar(15) NOT NULL default '',
  `enabled` varchar(1) NOT NULL default '1',
  PRIMARY KEY  (`number`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `location`
--


/*!40000 ALTER TABLE `location` DISABLE KEYS */;
LOCK TABLES `location` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `location` ENABLE KEYS */;

--
-- Table structure for table `locks`
--

DROP TABLE IF EXISTS `locks`;
CREATE TABLE `locks` (
  `incident` varchar(255) NOT NULL default '',
  `time` time NOT NULL default '00:00:00',
  `id` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`incident`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `locks`
--


/*!40000 ALTER TABLE `locks` DISABLE KEYS */;
LOCK TABLES `locks` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `locks` ENABLE KEYS */;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
CREATE TABLE `reports` (
  `number` int(11) NOT NULL,
  `title` varchar(50) NOT NULL,
  `owner` smallint(4) NOT NULL,
  `ag` varchar(1) default NULL,
  `agent` text,
  `gr` varchar(1) default NULL,
  `grp` text,
  `us` varchar(1) default NULL,
  `usr` text,
  `lo` varchar(1) default NULL,
  `location` text,
  `status` varchar(1) default NULL,
  `status1` text,
  `severity` varchar(1) default NULL,
  `severity1` text,
  `type` varchar(1) default NULL,
  `type1` text,
  `logged` varchar(1) default NULL,
  `logged1` text,
  `closer` varchar(1) default NULL,
  `closer1` text,
  PRIMARY KEY  (`number`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
LOCK TABLES `reports` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;


--
-- Table structure for table `theme`
--

DROP TABLE IF EXISTS `theme`;
CREATE TABLE `theme` (
  `number` int(11) NOT NULL,
  `name` varchar(20) NOT NULL,
  `background` varchar(6) NOT NULL,
  `table_background` varchar(6) NOT NULL,
  `table_border` varchar(6) NOT NULL,
  PRIMARY KEY  (`number`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `theme`
--


/*!40000 ALTER TABLE `theme` DISABLE KEYS */;
LOCK TABLES `theme` WRITE;
INSERT INTO `theme` VALUES ('0', 'Default', 'CCCCCC', '3399FF', '333366');
UNLOCK TABLES;
/*!40000 ALTER TABLE `theme` ENABLE KEYS */;

--
-- Table structure for table `type`
--

DROP TABLE IF EXISTS `type`;
CREATE TABLE `type` (
  `number` smallint(4) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `enabled` varchar(1) NOT NULL default '1',
  PRIMARY KEY  (`number`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `type`
--


/*!40000 ALTER TABLE `type` DISABLE KEYS */;
LOCK TABLES `type` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `type` ENABLE KEYS */;

--
-- Table structure for table `universal`
--

DROP TABLE IF EXISTS `universal`;
CREATE TABLE `universal` (
  `notify` varchar(1) NOT NULL default '0',
  `address` varchar(40) NOT NULL default '',
  `name` varchar(50) NOT NULL default '',
  `version` varchar(5) NOT NULL default '',
  `year` varchar(5) NOT NULL default '',
  `textsize` varchar(8) NOT NULL default 'small',
  `tabletextsize` varchar(8) NOT NULL default 'x-small',
  `theme` int(11) NOT NULL default '1',
  `assign_attach` varchar(1) NOT NULL default '0',
  `assign_diary` varchar(1) NOT NULL default '0',
  `user_sub` varchar(1) NOT NULL default '0',
  `user_search` varchar(1) NOT NULL default '0',
  `user_reg` varchar(1) NOT NULL default '0',
  `res_text` text NOT NULL,
  `use_res_text` varchar(1) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `universal`
--


/*!40000 ALTER TABLE `universal` DISABLE KEYS */;
LOCK TABLES `universal` WRITE;
INSERT INTO `universal` VALUES ('1','yourgroup@yourorg.tld','YourGroup','2.5.1','2008','x-small','small','0','0','0','0','0','0','','0');
UNLOCK TABLES;
/*!40000 ALTER TABLE `universal` ENABLE KEYS */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `number` smallint(6) NOT NULL default '0',
  `fname` varchar(10) NOT NULL default '',
  `lname` varchar(20) NOT NULL default '',
  `location` smallint(4) NOT NULL default '0',
  `dept` varchar(20) NOT NULL default '',
  `phone` varchar(15) NOT NULL default '',
  `email` varchar(40) NOT NULL default '',
  `title` varchar(40) NOT NULL default '',
  `enabled` char(1) NOT NULL default '1',
  `system` varchar(8) NOT NULL default '',
  `authcode` varchar(15) default NULL,
  PRIMARY KEY  (`number`),
  KEY `index.usr.loc` (`location`),
  KEY `index.usr.dep` (`dept`),
  UNIQUE KEY `users.authcode.unique` (`authcode`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `users`
--


/*!40000 ALTER TABLE `users` DISABLE KEYS */;
LOCK TABLES `users` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

