<?php
 /*
   Tiquit Is Quality User Incident Tracking
   Copyright (C) 2006 Jonathan Ciesla
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
  */
require_once("config.php");
require_once("functionlib.php");
authentication(0, 0);
favicon();
  
function inc_date($worker){
  $chunks = explode("-", $worker);   
  
  $chunks[2]++;
  if(($chunks[1]==1)||($chunks[1]==3)||($chunks[1]==5)||($chunks[1]==7)||($chunks[1]==8)||($chunks[1]==10)||($chunks[1]==12)){
    if($chunks[2]>31){
      $chunks[2]=1; 
      if($chunks[1]==12){$chunks[1]=1; $chunks[0]++;} else {$chunks[1]++;};
    }
  } elseif(($chunks[1]==4)||($chunks[1]==6)||($chunks[1]==9)||($chunks[1]==11)){
    if($chunks[2]>30){
      $chunks[2]=1;
      $chunks[1]++;
    }
  } elseif(($chunks[1]==2)){
    if(gettype(($chunks[0]/4))=='integer'){$leap=1;}else{$leap=0;};
    echo $leap;
    if($chunks[2]>=(29+$leap)){
      $chunks[2]=1;
      $chunks[1]++;
    }
  }
  
  if(strlen($chunks[1])<2){$chunks[1] = "0" . $chunks[1];};
  if(strlen($chunks[2])<2){$chunks[2] = "0" . $chunks[2];};
  
  $worker = implode("-", $chunks);
  return $worker;
};

function valid_date($fodder){
  $chunks = explode("-", $fodder);
  $answer = checkdate($chunks[1], $chunks[2], $chunks[0]);
  return $answer;
};

$link = dbms_connect($dbhost, $dbuser, $dbpass, $dbname);
echo "<link rel=stylesheet href=css.php>";
echo "<title>$sitetitle</title>";
echo "<h1>$sitetitle</h1>";

$date1 = $_POST['date1'];
$date2 = $_POST['date2'];

if(!$date2){$date2=$date1;};

if(valid_date($date1)&&valid_date($date2)&&($date1<=$date2)){

  echo "<table border=1 align=center>";
  echo "<CAPTION><b>Incidents logged $date1 - $date2</b></CAPTION>";
  echo "<tr><th>#</th><th>User</th><th>Severity</th><th>Agent</th><th>Type</th><th>Description</th><th>Date</th><th>Status</th></tr>";
  $enddate = inc_date($date2);
  while($date1 != $enddate){
    $query = "SELECT number,usr,agent,type,description,date,status,severity FROM incident WHERE date LIKE '%$date1%' ORDER BY date ASC";
    $result = dbms_query($query);
    while($line = dbms_fetch_array($result, "ASSOC")){
      echo "<tr>";
      
      if($line['status']=="Open"){$stat_color = "#00FF00";};
      if($line['status']=="Hold"){$stat_color = "#FFFF00";};
      if($line['status']=="Closed"){$stat_color = "#C0C0C0";};
      
      echo "<td bgcolor=$stat_color>{$line['number']}</td>";
      
      $query1 = "SELECT lname,fname FROM users WHERE number ='{$line['usr']}'";
      $result1 = dbms_query($query1);
      $line1 = dbms_fetch_array($result1, "ASSOC");
      dbms_free_result($result1);
      $print_name = $line1['lname'] . ", " . $line1['fname'];
      echo "<td bgcolor=$stat_color>$print_name</td>";
      
      if($line['severity']=="1"){$sev_color = "#FF0000";};
      if($line['severity']=="2"){$sev_color = "#FF9900";};
      if($line['severity']=="3"){$sev_color = "#FFFF00";};
      if($line['severity']=="4"){$sev_color = "#00FF00";};
      if($line['severity']=="5"){$sev_color = "#0000FF";};
  
      echo "<td bgcolor=$sev_color>{$line['severity']}</td>";
    
      $print_type = agent_name($line['agent']);
      echo "<td bgcolor=$stat_color>$print_type</td>";

      $print_type = type_name($line['type']);
      echo "<td bgcolor=$stat_color>$print_type</td>";
      
      echo "<td bgcolor=$stat_color>{$line['description']}</td>";
      
      echo "<td bgcolor=$stat_color>{$line['date']}</td>";
      
      echo "<td bgcolor=$stat_color>";
      echo "<form action=incident_update.php method=post>";
      echo "<input type=hidden name=num value=\"{$line['number']}\">";
      echo "<input type=submit value={$line['status']}>";
      echo "</form>";
      echo "</td>";
      
      echo "</tr>";
    };
    dbms_free_result($result);
    $date1 = inc_date($date1);
  };
  echo "</table>";  
  
} else { echo "Invalid date(s)";};

echo "<br />";
echo "<form action=main.php method=post>";
echo "<input type=submit value=Back />";
echo "</form>";

?>