/***************************************************************************
    smb4kglobal  -  This is the global namespace for Smb4K.
                             -------------------
    begin                : Sa Apr 2 2005
    copyright            : (C) 2005-2008 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// KDE includes
#include <kconfig.h>
#include <kdebug.h>

// application specific includes
#include <smb4kglobal.h>
#include <smb4kglobal_p.h>
#include <smb4kdefs.h>


static Smb4KGlobalPrivate p;


int Smb4KGlobal::timerInterval()
{
  return TIMER_INTERVAL;
}


const QString &Smb4KGlobal::tempDir()
{
  return p.tempDir();
}


QList<Smb4KWorkgroup *> *Smb4KGlobal::workgroupsList()
{
  return &p.workgroupsList;
}


QList<Smb4KHost *> *Smb4KGlobal::hostsList()
{
  return &p.hostsList;
}


QList<Smb4KShare *> *Smb4KGlobal::mountedSharesList()
{
  return &p.mountedSharesList;
}


Smb4KWorkgroup *Smb4KGlobal::findWorkgroup( const QString &name )
{
  Smb4KWorkgroup *workgroup = NULL;

  for ( int i = 0; i < p.workgroupsList.size(); ++i )
  {
    if ( QString::compare( p.workgroupsList.at( i )->name(),
         name, Qt::CaseInsensitive ) == 0 )
    {
      workgroup = p.workgroupsList.at( i );

      break;
    }
    else
    {
      continue;
    }
  }

  return workgroup;
}


Smb4KHost *Smb4KGlobal::findHost( const QString &name, const QString &workgroup )
{
  Smb4KHost *host = NULL;

  for ( int i = 0; i < p.hostsList.size(); ++i )
  {
    if ( (workgroup.isEmpty() ||
         QString::compare( p.hostsList.at( i )->workgroup(),
         workgroup, Qt::CaseInsensitive ) == 0) &&
         QString::compare( p.hostsList.at( i )->name(), name,
         Qt::CaseInsensitive ) == 0 )
    {
      host = p.hostsList.at( i );

      break;
    }
    else
    {
      continue;
    }
  }

  return host;
}


Smb4KShare* Smb4KGlobal::findShareByPath( const QByteArray &path )
{
  if ( path.isEmpty() || p.mountedSharesList.isEmpty() )
  {
    return NULL;
  }

  Smb4KShare *share = NULL;

  for ( int i = 0; i < Smb4KGlobal::mountedSharesList()->size(); ++i )
  {
    if ( path.toUpper() == p.mountedSharesList.at( i )->path().toUpper() ||
         path.toUpper() == p.mountedSharesList.at( i )->canonicalPath().toUpper() )
    {
      share = p.mountedSharesList.at( i );

      break;
    }
    else
    {
      continue;
    }
  }

  return share;
}


QList<Smb4KShare *> Smb4KGlobal::findShareByUNC( const QString &unc )
{
  QList<Smb4KShare *> list;

  if ( unc.isEmpty() || p.mountedSharesList.isEmpty() )
  {
    return list;  // is empty
  }

  QString u = unc;

  for ( int i = 0; i < p.mountedSharesList.size(); ++i )
  {
#ifdef __FreeBSD__
    QString clean_unc;

    if ( p.mountedSharesList.at( i )->unc().contains( "@" ) )
    {
      QString temp_host = unc.section( "@", 1, 1 ).section( "/", 0, 0 ).trimmed();
      QString temp_share = unc.section( "/", 3, 3 ).trimmed();

      clean_unc = "//"+temp_host+"/"+temp_share;
    }
    else
    {
      clean_unc = p.mountedSharesList.at( i )->unc();
    }
#endif

#ifndef __FreeBSD__
    if( QString::compare( unc, p.mountedSharesList.at( i )->unc(), Qt::CaseInsensitive ) == 0 ||
        QString::compare( u.replace( " ", "_" ), p.mountedSharesList.at( i )->unc(), Qt::CaseInsensitive ) == 0 )
#else
    if( QString::compare( unc, p.mountedSharesList.at( i )->unc(), Qt::CaseInsensitive ) == 0 ||
        QString::compare( u.replace( " ", "_" ), p.mountedSharesList.at( i )->unc(), Qt::CaseInsensitive ) == 0 ||
        QString::compare( unc, clean_unc, Qt::CaseInsensitive ) == 0 ||
        QString::compare( u.replace( " ", "_" ), clean_unc, Qt::CaseInsensitive ) == 0 )
#endif
    {
      list.append( p.mountedSharesList.at( i ) );

      continue;
    }
    else
    {
      continue;
    }
  }

  return list;
}


QList<Smb4KShare*> Smb4KGlobal::findInaccessibleShares()
{
  QList<Smb4KShare *> inaccessible_shares;

  for ( int i = 0; i < p.mountedSharesList.size(); ++i )
  {
    if ( p.mountedSharesList.at( i )->isInaccessible() )
    {
      inaccessible_shares.append( p.mountedSharesList.at( i ) );

      continue;
    }
    else
    {
      continue;
    }
  }

  return inaccessible_shares;
}

